/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.IO;

abstract class WalkRemoteObjectDatabase {
    static final String ROOT_DIR = "../";
    static final String INFO_PACKS = "info/packs";
    static final String INFO_REFS = "../info/refs";

    WalkRemoteObjectDatabase() {
    }

    abstract URIish getURI();

    abstract Collection<String> getPackNames() throws IOException;

    abstract Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException;

    abstract FileStream open(String var1) throws FileNotFoundException, IOException;

    abstract WalkRemoteObjectDatabase openAlternate(String var1) throws IOException;

    abstract void close();

    void deleteFile(String path) throws IOException {
        throw new IOException(MessageFormat.format(JGitText.get().deletingNotSupported, path));
    }

    OutputStream writeFile(String path, ProgressMonitor monitor, String monitorTask) throws IOException {
        throw new IOException(MessageFormat.format(JGitText.get().writingNotSupported, path));
    }

    void writeFile(String path, byte[] data) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream os = this.writeFile(path, null, null);){
            os.write(data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void deleteRef(String name) throws IOException {
        this.deleteFile(ROOT_DIR + name);
    }

    void deleteRefLog(String name) throws IOException {
        this.deleteFile("../logs/" + name);
    }

    void writeRef(String name, ObjectId value) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream(41);
        value.copyTo(b);
        b.write(10);
        this.writeFile(ROOT_DIR + name, b.toByteArray());
    }

    void writeInfoPacks(Collection<String> packNames) throws IOException {
        StringBuilder w = new StringBuilder();
        for (String n : packNames) {
            w.append("P ");
            w.append(n);
            w.append('\n');
        }
        this.writeFile(INFO_PACKS, Constants.encodeASCII(w.toString()));
    }

    BufferedReader openReader(String path) throws IOException {
        InputStream is = this.open((String)path).in;
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    Collection<WalkRemoteObjectDatabase> readAlternates(String listPath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = this.openReader(listPath);){
            Object line;
            ArrayList<WalkRemoteObjectDatabase> alts = new ArrayList<WalkRemoteObjectDatabase>();
            while ((line = br.readLine()) != null) {
                if (!((String)line).endsWith("/")) {
                    line = (String)line + "/";
                }
                alts.add(this.openAlternate((String)line));
            }
            return alts;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void readPackedRefs(Map<String, Ref> avail) throws TransportException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader br = this.openReader("../packed-refs");){
                this.readPackedRefsImpl(avail, br);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            throw new TransportException(this.getURI(), JGitText.get().errorInPackedRefs, e);
        }
    }

    private void readPackedRefsImpl(Map<String, Ref> avail, BufferedReader br) throws IOException {
        String line;
        Ref last = null;
        boolean peeled = false;
        while ((line = br.readLine()) != null) {
            if (line.charAt(0) == '#') {
                if (!line.startsWith("# pack-refs with:")) continue;
                line = line.substring("# pack-refs with:".length());
                peeled = line.contains(" peeled");
                continue;
            }
            if (line.charAt(0) == '^') {
                if (last == null) {
                    throw new TransportException(JGitText.get().peeledLineBeforeRef);
                }
                ObjectId id = ObjectId.fromString(line.substring(1));
                last = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last.getName(), last.getObjectId(), id);
                avail.put(last.getName(), last);
                continue;
            }
            int sp = line.indexOf(32);
            if (sp < 0) {
                throw new TransportException(MessageFormat.format(JGitText.get().unrecognizedRef, line));
            }
            ObjectId id = ObjectId.fromString(line.substring(0, sp));
            String name = line.substring(sp + 1);
            last = peeled ? new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id) : new ObjectIdRef.Unpeeled(Ref.Storage.PACKED, name, id);
            avail.put(last.getName(), last);
        }
    }

    static final class FileStream {
        final InputStream in;
        final long length;

        FileStream(InputStream i) {
            this.in = i;
            this.length = -1L;
        }

        FileStream(InputStream i, long n) {
            this.in = i;
            this.length = n;
        }

        byte[] toArray() throws IOException {
            try {
                int n;
                if (this.length >= 0L) {
                    byte[] r = new byte[(int)this.length];
                    IO.readFully(this.in, r, 0, r.length);
                    byte[] byArray = r;
                    return byArray;
                }
                ByteArrayOutputStream r = new ByteArrayOutputStream();
                byte[] buf = new byte[2048];
                while ((n = this.in.read(buf)) >= 0) {
                    r.write(buf, 0, n);
                }
                byte[] byArray = r.toByteArray();
                return byArray;
            }
            finally {
                this.in.close();
            }
        }
    }
}

