/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent;

import java.util.ServiceLoader;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;

public final class ConnectorFactoryProvider {
    private static volatile ConnectorFactory INSTANCE = ConnectorFactoryProvider.loadDefaultFactory();

    private static ConnectorFactory loadDefaultFactory() {
        ServiceLoader<ConnectorFactory> loader = ServiceLoader.load(ConnectorFactory.class);
        for (ConnectorFactory candidate : loader) {
            if (!candidate.isSupported()) continue;
            return candidate;
        }
        return null;
    }

    public static ConnectorFactory getDefaultFactory() {
        return INSTANCE;
    }

    public static void setDefaultFactory(ConnectorFactory factory) {
        INSTANCE = factory == null ? ConnectorFactoryProvider.loadDefaultFactory() : factory;
    }

    private ConnectorFactoryProvider() {
    }
}

