/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSubscriberMergeContext;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRoot;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class GitChangeSetContentProvider
extends SynchronizationContentProvider {
    private ITreeContentProvider provider;
    private GitModelRoot modelRoot;
    private Map<Object, ResourceTraversal[]> traversalCache = new HashMap<Object, ResourceTraversal[]>();

    public boolean hasChildren(Object element) {
        if (element instanceof GitModelBlob) {
            return false;
        }
        if (element instanceof GitModelObjectContainer) {
            return ((GitModelObjectContainer)((Object)element)).getChildren().length > 0;
        }
        return super.hasChildren(element);
    }

    protected ITreeContentProvider getDelegateContentProvider() {
        if (this.provider == null) {
            this.provider = new WorkbenchContentProvider();
        }
        return this.provider;
    }

    protected String getModelProviderId() {
        return "org.eclipse.egit.ui.changeSetModel";
    }

    protected Object getModelRoot() {
        if (this.modelRoot == null) {
            GitSubscriberMergeContext context = (GitSubscriberMergeContext)this.getContext();
            this.modelRoot = new GitModelRoot(context.getSyncData());
        }
        return this.modelRoot;
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        if (object instanceof IAdaptable) {
            if (this.traversalCache.containsKey(object)) {
                return this.traversalCache.get(object);
            }
            ResourceMapping rm = this.getResourceMapping(object);
            if (rm == null) {
                return null;
            }
            GitSubscriberMergeContext ctx = (GitSubscriberMergeContext)this.getContext();
            GitSubscriberResourceMappingContext rmCtx = new GitSubscriberResourceMappingContext((GitResourceVariantTreeSubscriber)ctx.getSubscriber(), ctx.getSyncData());
            try {
                ResourceTraversal[] traversals = rm.getTraversals((ResourceMappingContext)rmCtx, (IProgressMonitor)new NullProgressMonitor());
                this.traversalCache.put(object, traversals);
                return traversals;
            }
            catch (CoreException e) {
                Activator.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    private ResourceMapping getResourceMapping(Object object) {
        return (ResourceMapping)Adapters.adapt((Object)object, ResourceMapping.class);
    }

    public void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
        }
        if (this.modelRoot != null) {
            this.modelRoot.dispose();
        }
        this.traversalCache.clear();
        super.dispose();
    }

    protected void refresh() {
        this.traversalCache.clear();
        super.refresh();
    }

    protected boolean isVisible(ISynchronizationContext context, Object object) {
        if (object instanceof GitModelRepository || object instanceof GitModelCommit || object instanceof GitModelCache) {
            int kind = ((GitModelObjectContainer)((Object)object)).getKind();
            switch (this.getConfiguration().getMode()) {
                case 2: {
                    return (kind & 8) != 0;
                }
                case 1: {
                    return (kind & 4) != 0;
                }
            }
        }
        return true;
    }
}

