/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.graph;

import org.eclipse.elk.alg.force.graph.FEdge;
import org.eclipse.elk.alg.force.graph.FParticle;
import org.eclipse.elk.alg.force.options.ForceOptions;
import org.eclipse.elk.core.math.KVector;

public final class FLabel
extends FParticle {
    private static final long serialVersionUID = 9047772256368142239L;
    private FEdge edge;
    private String text;

    public FLabel(FEdge fedge, String text) {
        this.edge = fedge;
        this.text = text;
        this.edge.getLabels().add(this);
    }

    public String toString() {
        if (this.text == null || this.text.length() == 0) {
            return "l[" + this.edge.toString() + "]";
        }
        return "l_" + this.text;
    }

    public String getText() {
        return this.text;
    }

    public FEdge getEdge() {
        return this.edge;
    }

    public void refreshPosition() {
        boolean placeInline = (Boolean)this.getProperty(ForceOptions.EDGE_LABELS_INLINE);
        KVector src = this.edge.getSource().getPosition();
        KVector tgt = this.edge.getTarget().getPosition();
        if (placeInline) {
            KVector srcToTgt = tgt.clone().sub(src).scale(0.5);
            KVector toLabelCenter = this.getSize().clone().scale(0.5);
            KVector newLabelPosition = src.clone().add(srcToTgt).sub(toLabelCenter);
            this.getPosition().set(newLabelPosition);
        } else {
            double spacing = (Double)this.edge.getProperty(ForceOptions.SPACING_EDGE_LABEL);
            KVector pos = this.getPosition();
            if (src.x >= tgt.x) {
                if (src.y >= tgt.y) {
                    pos.x = tgt.x + (src.x - tgt.x) / 2.0 + spacing;
                    pos.y = tgt.y + (src.y - tgt.y) / 2.0 - spacing - this.getSize().y;
                } else {
                    pos.x = tgt.x + (src.x - tgt.x) / 2.0 + spacing;
                    pos.y = src.y + (tgt.y - src.y) / 2.0 + spacing;
                }
            } else if (src.y >= tgt.y) {
                pos.x = src.x + (tgt.x - src.x) / 2.0 + spacing;
                pos.y = tgt.y + (src.y - tgt.y) / 2.0 + spacing;
            } else {
                pos.x = src.x + (tgt.x - src.x) / 2.0 + spacing;
                pos.y = src.y + (tgt.y - src.y) / 2.0 - spacing - this.getSize().y;
            }
        }
    }
}

