/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SemiInteractiveCrossMinProcessor
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Semi-Interactive Crossing Minimization Processor", 1.0f);
        for (Layer l : layeredGraph) {
            l.getNodes().stream().filter(n -> n.getType() == LNode.NodeType.NORMAL).filter(n -> n.getAllProperties().containsKey(LayeredOptions.POSITION)).sorted((n1, n2) -> {
                KVector origPos1 = (KVector)n1.getProperty(LayeredOptions.POSITION);
                KVector origPos2 = (KVector)n2.getProperty(LayeredOptions.POSITION);
                return Double.compare(origPos1.y, origPos2.y);
            }).reduce((prev, cur) -> {
                ((List)prev.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS)).add(cur);
                return cur;
            });
        }
        progressMonitor.done();
    }
}

