/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopOpposingSegment;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public final class SelfLoopBendpointCalculationUtil {
    private static final double DISTANCE = 10.0;
    private static final double ANCHOR_HEIGHT = 5.0;
    private static final double CORNER_CUT = 2.5;

    private SelfLoopBendpointCalculationUtil() {
    }

    public static List<KVector> generateCornerBendpoints(SelfLoopNode nodeRep, SelfLoopPort source, SelfLoopPort target, KVector firstBendpoint, KVector secondBendpoint, SelfLoopEdge edge) {
        ArrayList<KVector> cornerBendpoints = new ArrayList<KVector>();
        KVector previousBendPoint = firstBendpoint.clone();
        PortSide sourceSide = source.getPortSide();
        PortSide targetSide = target.getPortSide();
        SelfLoopRoutingDirection routingDirection = source.getDirection();
        if (source.getDirection() == SelfLoopRoutingDirection.BOTH) {
            routingDirection = target.getDirection() == SelfLoopRoutingDirection.LEFT ? SelfLoopRoutingDirection.RIGHT : SelfLoopRoutingDirection.LEFT;
        }
        PortSide nextside = routingDirection == SelfLoopRoutingDirection.LEFT ? sourceSide.left() : sourceSide.right();
        do {
            SelfLoopNodeSide nodeSide = nodeRep.getNodeSide(nextside);
            SelfLoopOpposingSegment segment = nodeSide.getOpposingSegments().get(edge);
            double middlePadding = 10.0 * (double)segment.getLevel() + 5.0;
            LNode node = source.getLPort().getNode();
            KVector secondCP = SelfLoopBendpointCalculationUtil.calculateOpposingCornerBendPoint(previousBendPoint, nextside, node.getSize(), middlePadding);
            cornerBendpoints.add(secondCP);
            previousBendPoint = secondCP;
        } while ((nextside = routingDirection == SelfLoopRoutingDirection.LEFT ? nextside.left() : nextside.right()) != targetSide);
        KVector secondCP = SelfLoopBendpointCalculationUtil.calculateCorner(previousBendPoint, secondBendpoint, target.getPortSide());
        cornerBendpoints.add(secondCP);
        return cornerBendpoints;
    }

    private static KVector calculateCorner(KVector firstBendPoint, KVector secondBendPoint, PortSide targetSide) {
        KVector cornerBendPoint = new KVector();
        switch (targetSide) {
            case NORTH: 
            case SOUTH: {
                cornerBendPoint.x = firstBendPoint.x;
                cornerBendPoint.y = secondBendPoint.y;
                break;
            }
            case EAST: 
            case WEST: {
                cornerBendPoint.x = secondBendPoint.x;
                cornerBendPoint.y = firstBendPoint.y;
            }
        }
        return cornerBendPoint;
    }

    public static KVector calculateCornerBendPoint(KVector firstBendpoint, PortSide firstSide, KVector secondBendpoint, PortSide secondSide) {
        double cornerX = 0.0;
        double cornerY = 0.0;
        switch (firstSide) {
            case WEST: {
                cornerX = firstBendpoint.x;
                break;
            }
            case EAST: {
                cornerX = firstBendpoint.x;
                break;
            }
            case NORTH: {
                cornerX = secondBendpoint.x;
                break;
            }
            case SOUTH: {
                cornerX = secondBendpoint.x;
                break;
            }
        }
        switch (secondSide) {
            case WEST: {
                cornerY = firstBendpoint.y;
                break;
            }
            case EAST: {
                cornerY = firstBendpoint.y;
                break;
            }
            case NORTH: {
                cornerY = secondBendpoint.y;
                break;
            }
            case SOUTH: {
                cornerY = secondBendpoint.y;
                break;
            }
        }
        KVector secondCP = new KVector(cornerX, cornerY);
        return secondCP;
    }

    public static KVector calculateOpposingCornerBendPoint(KVector previousBendPoint, PortSide opposingSide, KVector nodeSize, double opposingSideDistance) {
        KVector secondCP = new KVector();
        switch (opposingSide) {
            case NORTH: {
                secondCP.x = previousBendPoint.x;
                secondCP.y = -opposingSideDistance;
                break;
            }
            case EAST: {
                secondCP.x = opposingSideDistance + nodeSize.x;
                secondCP.y = previousBendPoint.y;
                break;
            }
            case SOUTH: {
                secondCP.x = previousBendPoint.x;
                secondCP.y = opposingSideDistance + nodeSize.y;
                break;
            }
            case WEST: {
                secondCP.x = -opposingSideDistance;
                secondCP.y = previousBendPoint.y;
            }
        }
        return secondCP;
    }

    public static List<KVector> cutCornerBendPoints(KVector firstBendpoint, PortSide side, SelfLoopRoutingDirection routingDirection) {
        ArrayList<KVector> cutCornerBendPoints = new ArrayList<KVector>();
        double direction = SplinesMath.portSideToDirection(side);
        KVector directionVector = new KVector(direction).scale(-1.0);
        KVector firstCutBendpoint = firstBendpoint.clone().add(directionVector.scale(2.5));
        cutCornerBendPoints.add(firstCutBendpoint);
        PortSide nextSide = routingDirection == SelfLoopRoutingDirection.LEFT ? side.left() : side.right();
        double directionSecondCut = SplinesMath.portSideToDirection(nextSide);
        KVector directionVectorSecondCut = new KVector(directionSecondCut);
        KVector secondCutBendpoint = firstBendpoint.clone().add(directionVectorSecondCut.scale(2.5));
        cutCornerBendPoints.add(secondCutBendpoint);
        return cutCornerBendPoints;
    }
}

