/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopLabel;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.labels.ILabelManager;
import org.eclipse.elk.core.labels.LabelManagementOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LabelManagementProcessor
implements ILayoutProcessor<LGraph> {
    private static final double MIN_WIDTH_PORT_LABELS = 20.0;
    private static final double MIN_WIDTH_NODE_LABELS = 40.0;
    private static final double MIN_WIDTH_EDGE_LABELS = 60.0;
    private boolean centerLabels;

    public LabelManagementProcessor(boolean centerLabels) {
        this.centerLabels = centerLabels;
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Label management", 1.0f);
        ILabelManager labelManager = (ILabelManager)layeredGraph.getProperty(LabelManagementOptions.LABEL_MANAGER);
        if (labelManager != null) {
            double edgeLabelSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_LABEL);
            double labelLabelSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_LABEL_LABEL);
            if (this.centerLabels) {
                this.manageCenterLabels(layeredGraph, labelManager, edgeLabelSpacing, labelLabelSpacing);
            } else {
                this.manageNonCenterLabels(layeredGraph, labelManager, labelLabelSpacing);
            }
        }
        monitor.done();
    }

    private void manageNonCenterLabels(LGraph lGraph, ILabelManager labelManager, double labelLabelSpacing) {
        boolean verticalLayout = ((Direction)lGraph.getProperty(LayeredOptions.DIRECTION)).isVertical();
        for (Layer layer : lGraph) {
            for (LNode node : layer) {
                if (node.getType() == LNode.NodeType.NORMAL) {
                    this.doManageLabels(labelManager, node.getLabels(), 40.0, labelLabelSpacing, verticalLayout);
                    List<LPort> ports = node.getPorts();
                    for (LPort port : ports) {
                        this.doManageLabels(labelManager, port.getLabels(), 20.0, labelLabelSpacing, verticalLayout);
                    }
                    if (node.hasProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION)) {
                        SelfLoopNode slNode = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
                        for (SelfLoopComponent component : slNode.getSelfLoopComponents()) {
                            SelfLoopLabel slLabel = component.getSelfLoopLabel();
                            if (slLabel == null) continue;
                            this.doManageLabels(labelManager, slLabel.getLabels(), 60.0, labelLabelSpacing, verticalLayout);
                        }
                    }
                    if (node.hasProperty(InternalProperties.TOP_COMMENTS)) {
                        this.doManageAttachedCommentLabels(labelManager, (List)node.getProperty(InternalProperties.TOP_COMMENTS), 40.0, verticalLayout);
                    }
                    if (node.hasProperty(InternalProperties.BOTTOM_COMMENTS)) {
                        this.doManageAttachedCommentLabels(labelManager, (List)node.getProperty(InternalProperties.BOTTOM_COMMENTS), 40.0, verticalLayout);
                    }
                }
                for (LEdge edge : node.getOutgoingEdges()) {
                    this.doManageLabels(labelManager, edge.getLabels(), 60.0, 0.0, verticalLayout);
                }
            }
        }
    }

    private void doManageAttachedCommentLabels(ILabelManager labelManager, List<LNode> commentNodes, double minWidthNodeLabels, boolean verticalLayout) {
        for (LNode commentNode : commentNodes) {
            if (commentNode.getLabels().isEmpty()) continue;
            this.doManageLabels(labelManager, commentNode.getLabels(), minWidthNodeLabels, 0.0, verticalLayout);
        }
    }

    private void manageCenterLabels(LGraph lGraph, ILabelManager labelManager, double edgeLabelSpacing, double labelLabelSpacing) {
        boolean verticalLayout = ((Direction)lGraph.getProperty(LayeredOptions.DIRECTION)).isVertical();
        for (Layer layer : lGraph) {
            double maxWidth = Math.max(60.0, LGraphUtil.findMaxNonDummyNodeWidth(layer, false));
            for (LNode node : layer) {
                if (node.getType() != LNode.NodeType.LABEL) continue;
                LEdge edge = node.getConnectedEdges().iterator().next();
                double edgeThickness = (Double)edge.getProperty(LayeredOptions.EDGE_THICKNESS);
                Iterable labels = (Iterable)node.getProperty(InternalProperties.REPRESENTED_LABELS);
                KVector spaceRequiredForLabels = this.doManageLabels(labelManager, labels, maxWidth, labelLabelSpacing, verticalLayout);
                node.getSize().x = spaceRequiredForLabels.x;
                node.getSize().y = spaceRequiredForLabels.y + edgeThickness + edgeLabelSpacing;
            }
        }
    }

    private KVector doManageLabels(ILabelManager labelManager, Iterable<LLabel> labels, double targetWidth, double labelLabelSpacing, boolean verticalLayout) {
        KVector requiredLabelSpace = new KVector();
        if (labels.iterator().hasNext()) {
            for (LLabel label : labels) {
                KVector newSize;
                KVector labelSize = label.getSize();
                Object origin = label.getProperty(InternalProperties.ORIGIN);
                if (origin != null && (newSize = labelManager.manageLabelSize(origin, targetWidth)) != null) {
                    if (verticalLayout) {
                        labelSize.x = newSize.y;
                        labelSize.y = newSize.x;
                    } else {
                        labelSize.x = newSize.x;
                        labelSize.y = newSize.y;
                    }
                }
                if (verticalLayout) {
                    requiredLabelSpace.x += labelLabelSpacing + label.getSize().x;
                    requiredLabelSpace.y = Math.max(requiredLabelSpace.y, labelSize.y);
                    continue;
                }
                requiredLabelSpace.x = Math.max(requiredLabelSpace.x, labelSize.x);
                requiredLabelSpace.y += labelLabelSpacing + label.getSize().y;
            }
            if (verticalLayout) {
                requiredLabelSpace.x -= labelLabelSpacing;
            } else {
                requiredLabelSpace.y -= labelLabelSpacing;
            }
        }
        return requiredLabelSpace;
    }
}

