/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.GreedySwitchHeuristic;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p3order.AbstractBarycenterPortDistributor;
import org.eclipse.elk.alg.layered.p3order.BarycenterHeuristic;
import org.eclipse.elk.alg.layered.p3order.ForsterConstraintResolver;
import org.eclipse.elk.alg.layered.p3order.ICrossingMinimizationHeuristic;
import org.eclipse.elk.alg.layered.p3order.ISweepPortDistributor;
import org.eclipse.elk.alg.layered.p3order.LayerSweepCrossingMinimizer;
import org.eclipse.elk.alg.layered.p3order.LayerSweepTypeDecider;
import org.eclipse.elk.alg.layered.p3order.SweepCopy;
import org.eclipse.elk.alg.layered.p3order.counting.AllCrossingsCounter;
import org.eclipse.elk.alg.layered.p3order.counting.IInitializable;

public class GraphInfoHolder
implements IInitializable {
    private LGraph lGraph;
    private LNode[][] currentNodeOrder;
    private SweepCopy currentlyBestNodeAndPortOrder;
    private SweepCopy bestNodeAndPortOrder;
    private int[] portPositions;
    private boolean useBottomUp;
    private List<LGraph> childGraphs;
    private boolean hasExternalPorts;
    private boolean hasParent;
    private GraphInfoHolder parentGraphData;
    private LNode parent;
    private LayerSweepTypeDecider layerSweepTypeDecider;
    private ICrossingMinimizationHeuristic crossMinimizer;
    private ISweepPortDistributor portDistributor;
    private AllCrossingsCounter crossingsCounter;
    private int nPorts;

    public GraphInfoHolder(LGraph graph, LayerSweepCrossingMinimizer.CrossMinType crossMinType, List<GraphInfoHolder> graphs) {
        this.lGraph = graph;
        this.currentNodeOrder = graph.toNodeArray();
        this.parent = this.lGraph.getParentNode();
        this.hasParent = this.parent != null;
        this.parentGraphData = this.hasParent ? graphs.get(this.parent.getGraph().id) : null;
        Set graphProperties = (Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        this.hasExternalPorts = graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS);
        this.childGraphs = Lists.newArrayList();
        this.crossingsCounter = new AllCrossingsCounter(this.currentNodeOrder);
        Random random = (Random)this.lGraph.getProperty(InternalProperties.RANDOM);
        this.portDistributor = ISweepPortDistributor.create(crossMinType, random, this.currentNodeOrder);
        this.layerSweepTypeDecider = new LayerSweepTypeDecider(this);
        ArrayList initializables = Lists.newArrayList((Object[])new IInitializable[]{this, this.crossingsCounter, this.layerSweepTypeDecider, this.portDistributor});
        if (crossMinType == LayerSweepCrossingMinimizer.CrossMinType.BARYCENTER) {
            ForsterConstraintResolver constraintResolver = new ForsterConstraintResolver(this.currentNodeOrder);
            initializables.add(constraintResolver);
            this.crossMinimizer = new BarycenterHeuristic(constraintResolver, random, (AbstractBarycenterPortDistributor)this.portDistributor, this.currentNodeOrder);
        } else {
            this.crossMinimizer = new GreedySwitchHeuristic(crossMinType, this);
        }
        initializables.add(this.crossMinimizer);
        IInitializable.init(initializables, this.currentNodeOrder);
        this.useBottomUp = this.layerSweepTypeDecider.useBottomUp();
    }

    public boolean dontSweepInto() {
        return this.useBottomUp;
    }

    public LGraph lGraph() {
        return this.lGraph;
    }

    public LNode[][] currentNodeOrder() {
        return this.currentNodeOrder;
    }

    public SweepCopy currentlyBestNodeAndPortOrder() {
        return this.currentlyBestNodeAndPortOrder;
    }

    public void setCurrentlyBestNodeAndPortOrder(SweepCopy currentlyBestNodeAndPortOrder) {
        this.currentlyBestNodeAndPortOrder = currentlyBestNodeAndPortOrder;
    }

    public SweepCopy bestNodeNPortOrder() {
        return this.bestNodeAndPortOrder;
    }

    public void setBestNodeNPortOrder(SweepCopy bestNodeNPortOrder) {
        this.bestNodeAndPortOrder = bestNodeNPortOrder;
    }

    public AllCrossingsCounter crossCounter() {
        return this.crossingsCounter;
    }

    public ICrossingMinimizationHeuristic crossMinimizer() {
        return this.crossMinimizer;
    }

    public ISweepPortDistributor portDistributor() {
        return this.portDistributor;
    }

    public LNode parent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.hasParent;
    }

    public Collection<LGraph> childGraphs() {
        return this.childGraphs;
    }

    public boolean hasExternalPorts() {
        return this.hasExternalPorts;
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.currentNodeOrder);
    }

    public SweepCopy getBestSweep() {
        return this.crossMinimizer.isDeterministic() ? this.currentlyBestNodeAndPortOrder() : this.bestNodeNPortOrder();
    }

    public GraphInfoHolder parentGraphData() {
        return this.parentGraphData;
    }

    public boolean crossMinDeterministic() {
        return this.crossMinimizer.isDeterministic();
    }

    public boolean crossMinAlwaysImproves() {
        return this.crossMinimizer.alwaysImproves();
    }

    public int[] portPositions() {
        return this.portPositions;
    }

    @Override
    public void initAtNodeLevel(int l, int n, LNode[][] nodeOrder) {
        LNode node = nodeOrder[l][n];
        LGraph nestedGraph = node.getNestedGraph();
        if (nestedGraph != null) {
            this.childGraphs.add(nestedGraph);
        }
    }

    @Override
    public void initAtPortLevel(int l, int n, int p, LNode[][] nodeOrder) {
        ++this.nPorts;
    }

    @Override
    public void initAfterTraversal() {
        this.portPositions = new int[this.nPorts];
    }
}

