/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.orthogonal;

import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.AbstractRoutingDirectionStrategy;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

class SouthToNorthRoutingStrategy
extends AbstractRoutingDirectionStrategy {
    SouthToNorthRoutingStrategy() {
    }

    @Override
    public double getPortPositionOnHyperNode(LPort port) {
        return port.getNode().getPosition().x + port.getPosition().x + port.getAnchor().x;
    }

    @Override
    public PortSide getSourcePortSide() {
        return PortSide.NORTH;
    }

    @Override
    public PortSide getTargetPortSide() {
        return PortSide.SOUTH;
    }

    @Override
    public void calculateBendPoints(HyperEdgeSegment hyperNode, double startPos, double edgeSpacing) {
        double y = startPos - (double)hyperNode.getRoutingSlot() * edgeSpacing;
        for (LPort port : hyperNode.getPorts()) {
            double sourcex = port.getAbsoluteAnchor().x;
            for (LEdge edge : port.getOutgoingEdges()) {
                if (edge.isSelfLoop()) continue;
                LPort target = edge.getTarget();
                double targetx = target.getAbsoluteAnchor().x;
                if (!(Math.abs(sourcex - targetx) > 0.001)) continue;
                KVector point1 = new KVector(sourcex, y);
                edge.getBendPoints().add((Object)point1);
                this.addJunctionPointIfNecessary(edge, hyperNode, point1, false);
                KVector point2 = new KVector(targetx, y);
                edge.getBendPoints().add((Object)point2);
                this.addJunctionPointIfNecessary(edge, hyperNode, point2, false);
            }
        }
    }
}

