/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral;

import java.math.BigInteger;
import java.util.LinkedList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.PeripheralValue;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdEnumeratedValueDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdEnumerationDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdFieldDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdObjectDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralRegisterVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralTreeVMNode;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;
import org.eclipse.embedcdt.packs.core.tree.Leaf;

public class PeripheralRegisterFieldVMNode
extends PeripheralRegisterVMNode {
    private SvdEnumeratedValueDMNode fEnumeratedValueDMNode;

    public PeripheralRegisterFieldVMNode(PeripheralTreeVMNode parent, SvdDMNode dmNode) {
        super(parent, dmNode);
        this.fValue.setDisplayFormat(1);
        this.fEnumeratedValueDMNode = null;
    }

    public SvdEnumeratedValueDMNode getEnumeratedValueDMNode() {
        if (this.fEnumeratedValueDMNode == null) {
            try {
                this.fEnumeratedValueDMNode = ((SvdFieldDMNode)this.fDMNode).findEnumeratedValue((PeripheralValue)this.getValue());
            }
            catch (DebugException e) {
                Activator.log((Throwable)e);
            }
        }
        return this.fEnumeratedValueDMNode;
    }

    public void clearEnumeratedValueDMNode() {
        this.fEnumeratedValueDMNode = null;
    }

    public String[] getEnumerationComboItems() {
        SvdEnumerationDMNode enumeration = ((SvdFieldDMNode)this.fDMNode).getWriteEnumerationDMNode();
        LinkedList<String> list = new LinkedList<String>();
        if (enumeration != null) {
            SvdObjectDMNode[] children = enumeration.getChildren();
            int i = 0;
            while (i < children.length) {
                SvdEnumeratedValueDMNode child = (SvdEnumeratedValueDMNode)children[i];
                String name = child.getDisplayName();
                BigInteger bigValue = SvdUtils.parseScaledNonNegativeBigInteger(child.getValue());
                list.add(String.format("0x%X: %s", bigValue, name));
                ++i;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public Integer getEnumerationComboIndex() {
        try {
            return ((SvdFieldDMNode)this.fDMNode).findEnumeratedComboIndex((PeripheralValue)this.getValue());
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    @Override
    public String getDisplayValue() {
        String readAction = this.getReadAction();
        if (!readAction.isEmpty()) {
            return "(read " + readAction + ")";
        }
        String value = this.getValueString();
        if (value.isEmpty()) {
            return null;
        }
        if (!this.isEnumeration()) {
            return value;
        }
        SvdEnumeratedValueDMNode node = this.getEnumeratedValueDMNode();
        if (node == null) {
            return value;
        }
        String enumerationName = "";
        if (node.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            enumerationName = node.getName();
        } else if (node.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            enumerationName = node.getDisplayName();
        }
        if (!enumerationName.isEmpty()) {
            value = String.valueOf(value) + ": " + enumerationName;
        }
        return value;
    }

    @Override
    public boolean supportsValueModification() {
        return !this.isReadOnly() && this.isReadAllowed();
    }

    @Override
    public boolean verifyValue(String expression) throws DebugException {
        boolean isValid = false;
        isValid = this.isEnumeration() ? PeripheralValue.isNumeric(expression) : PeripheralValue.isNumeric(expression);
        return isValid;
    }

    @Override
    protected void update(BigInteger newValue) {
        boolean sameValue = this.getPeripheralValue().getBigValue().equals(newValue);
        if (!sameValue) {
            this.clearEnumeratedValueDMNode();
            PeripheralRegisterVMNode parent = (PeripheralRegisterVMNode)this.getParent();
            PeripheralValue parentValue = null;
            parentValue = parent.getPeripheralValue();
            BigInteger bigValue = parentValue.isNumeric() ? parentValue.getBigValue() : BigInteger.ZERO;
            bigValue = bigValue.andNot(this.getBitMask().shiftLeft(this.getOffsetBits()));
            bigValue = bigValue.or(newValue.and(this.getBitMask()).shiftLeft(this.getOffsetBits()));
            parent.update(bigValue);
        }
    }

    public void updateFieldValueFromParent() {
        BigInteger bigValue;
        PeripheralRegisterVMNode parent = (PeripheralRegisterVMNode)this.getParent();
        PeripheralValue parentValue = parent.getPeripheralValue();
        if (parentValue.isNumeric()) {
            bigValue = parentValue.getBigValue();
            bigValue = bigValue.shiftRight(this.getOffsetBits()).and(this.getBitMask());
        } else {
            bigValue = BigInteger.ZERO;
        }
        this.setChanged(this.getPeripheralValue().update(bigValue));
    }

    @Override
    public String getDisplayNodeType() {
        return "Field";
    }

    @Override
    public String getImageName() {
        return "field";
    }

    @Override
    public String getDisplayAddress() {
        return this.convertFieldToString();
    }

    @Override
    public String getDisplayOffset() {
        return this.convertFieldToString();
    }

    @Override
    public String getDisplayResetValue() {
        if (this.fDMNode instanceof SvdFieldDMNode) {
            String resetValue = ((SvdFieldDMNode)this.fDMNode).getResetValue();
            if (resetValue.isEmpty()) {
                return null;
            }
            String resetMask = ((SvdFieldDMNode)this.fDMNode).getResetMask();
            if (resetValue.isEmpty()) {
                return resetValue;
            }
            return String.valueOf(resetValue) + "/" + resetMask;
        }
        return null;
    }

    private String convertFieldToString() {
        int msb;
        int lsb = this.getOffsetBits();
        if (lsb == (msb = lsb + this.getWidthBits() - 1)) {
            return String.format("[%d]", lsb);
        }
        return String.format("[%d:%d]", msb, lsb);
    }

    @Override
    public int getOffsetBits() {
        return ((SvdFieldDMNode)this.fDMNode).getOffset();
    }

    @Override
    public int getWidthBits() {
        return ((SvdFieldDMNode)this.fDMNode).getWidthBits();
    }

    public boolean isEnumeration() {
        return ((SvdFieldDMNode)this.fDMNode).isEnumeration();
    }

    @Override
    public BigInteger getThisBigAddressOffset() {
        return BigInteger.ZERO;
    }
}

