/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.properties;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.Activator;
import org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.Messages;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.DefaultPreferences;
import org.eclipse.embedcdt.managedbuild.cross.core.preferences.PersistentPreferences;
import org.eclipse.embedcdt.managedbuild.cross.riscv.core.ToolchainDefinition;
import org.eclipse.embedcdt.ui.FieldEditorPropertyPage;
import org.eclipse.embedcdt.ui.LabelFakeFieldEditor;
import org.eclipse.embedcdt.ui.XpackDirectoryNotStrictFieldEditor;
import org.eclipse.embedcdt.ui.preferences.ScopedPreferenceStoreWithoutDefaults;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ProjectToolchainsPathPropertiesPage
extends FieldEditorPropertyPage {
    public static final String ID = "org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.properties.toolchainsPage";
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
    private DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();

    public ProjectToolchainsPathPropertiesPage() {
        super(1);
        this.setDescription(Messages.ProjectToolchainsPathsPropertiesPage_description);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return new ScopedPreferenceStoreWithoutDefaults((IScopeContext)new ProjectScope((IProject)element), "org.eclipse.embedcdt.managedbuild.cross.riscv.core");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Link link = new Link(parent, 0);
        link.setText(Messages.ProjectToolchainsPathPropertiesPage_GlobalSettings_link);
        link.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        link.addListener(13, e -> PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferencePage.globalToolchainsPaths", (String[])new String[]{"org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferencePage.workspaceToolchainsPaths", "org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferencePage.globalToolchainsPaths"}, null).open());
        link = new Link(parent, 0);
        link.setText(Messages.ProjectToolchainsPathPropertiesPage_WorkspaceSettings_link);
        link.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        link.addListener(13, e -> PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferencePage.workspaceToolchainsPaths", (String[])new String[]{"org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferencePage.workspaceToolchainsPaths", "org.eclipse.embedcdt.internal.managedbuild.cross.riscv.ui.preferencePage.globalToolchainsPaths"}, null).open());
        TreeMap<ToolchainDefinition, Set> toolchains = new TreeMap<ToolchainDefinition, Set>(Comparator.comparing(org.eclipse.embedcdt.managedbuild.cross.core.ToolchainDefinition::getName));
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            void var9_16;
            IProject project = (IProject)element;
            IConfiguration[] configs = EclipseUtils.getConfigurationsForProject((IProject)project);
            boolean allConfigsUseSameToolchain = true;
            Object var9_15 = null;
            if (configs != null) {
                IConfiguration[] iConfigurationArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    block31: {
                        IConfiguration config = iConfigurationArray[n2];
                        IToolChain toolchain = config.getToolChain();
                        if (toolchain != null) {
                            IOption optionName;
                            IOption optionId = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.id");
                            if (optionId != null) {
                                try {
                                    String toolchainId = optionId.getStringValue();
                                    int ix = ToolchainDefinition.findToolchainById((String)toolchainId);
                                    ToolchainDefinition toolchainDefinition = ToolchainDefinition.getToolchain((int)ix);
                                    if (var9_16 == null) {
                                        ToolchainDefinition toolchainDefinition2 = toolchainDefinition;
                                    } else if (!var9_16.equals(toolchainDefinition)) {
                                        allConfigsUseSameToolchain = false;
                                    }
                                    Set buildConfigsSet = toolchains.computeIfAbsent(toolchainDefinition, x -> new TreeSet());
                                    buildConfigsSet.add(config.getName());
                                    break block31;
                                }
                                catch (BuildException toolchainId) {
                                }
                                catch (IndexOutOfBoundsException toolchainId) {
                                    // empty catch block
                                }
                            }
                            if ((optionName = toolchain.getOptionBySuperClassId("ilg.gnumcueclipse.managedbuild.cross.riscv.option.toolchain.name")) != null) {
                                try {
                                    String toolchainName = optionName.getStringValue();
                                    int ix = ToolchainDefinition.findToolchainByName((String)toolchainName);
                                    ToolchainDefinition toolchainDefinition = ToolchainDefinition.getToolchain((int)ix);
                                    if (var9_16 == null) {
                                        ToolchainDefinition toolchainDefinition3 = toolchainDefinition;
                                    } else if (!var9_16.equals(toolchainDefinition)) {
                                        allConfigsUseSameToolchain = false;
                                    }
                                    Set buildConfigsSet = toolchains.computeIfAbsent(toolchainDefinition, x -> new TreeSet());
                                    buildConfigsSet.add(config.getName());
                                }
                                catch (BuildException toolchainName) {
                                }
                                catch (IndexOutOfBoundsException toolchainName) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            if (allConfigsUseSameToolchain && var9_16 != null) {
                Set set = (Set)toolchains.get(var9_16);
                set.clear();
            }
        }
        if (toolchains.isEmpty()) {
            try {
                String toolchainId = this.fPersistentPreferences.getToolchainId();
                int ix = ToolchainDefinition.findToolchainById((String)toolchainId);
                toolchains.computeIfAbsent(ToolchainDefinition.getToolchain((int)ix), x -> Set.of());
            }
            catch (IndexOutOfBoundsException toolchainId) {
                // empty catch block
            }
        }
        if (toolchains.isEmpty()) {
            try {
                String toolchainName = this.fPersistentPreferences.getToolchainName();
                int ix = ToolchainDefinition.findToolchainByName((String)toolchainName);
                toolchains.computeIfAbsent(ToolchainDefinition.getToolchain((int)ix), x -> Set.of());
            }
            catch (IndexOutOfBoundsException toolchainName) {
                // empty catch block
            }
        }
        if (toolchains.isEmpty()) {
            int ix = ToolchainDefinition.getDefault();
            toolchains.computeIfAbsent(ToolchainDefinition.getToolchain((int)ix), x -> Set.of());
        }
        Group group = new Group(parent, 0);
        group.setText(Messages.GlobalToolchainsPathsPreferencesPage_ToolchainPathGroup_label);
        GridLayout groupLayout = new GridLayout(4, false);
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        boolean first = true;
        for (Map.Entry entry : toolchains.entrySet()) {
            if (first) {
                first = false;
            } else {
                Label verticalSpacer = new Label((Composite)group, 0);
                GridData layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
                verticalSpacer.setLayoutData((Object)layoutData);
                verticalSpacer.setText("");
            }
            ToolchainDefinition toolchain = (ToolchainDefinition)entry.getKey();
            Set configSet = (Set)entry.getValue();
            Label message = new Label((Composite)group, 64);
            GridData layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
            message.setLayoutData((Object)layoutData);
            if (configSet.isEmpty()) {
                message.setText(Messages.ProjectToolchainsPathPropertiesPage_ToolchainMessageAllConfigs_label);
            } else {
                String collected = String.join((CharSequence)", ", configSet);
                message.setText(NLS.bind((String)Messages.ProjectToolchainsPathPropertiesPage_ToolchainMessageSomeConfigs_label, (Object)collected));
            }
            PixelConverter pixelConverter = new PixelConverter((Control)message);
            layoutData.widthHint = pixelConverter.convertWidthInCharsToPixels(Math.min(message.getText().length(), 100));
            LabelFakeFieldEditor labelField = new LabelFakeFieldEditor(toolchain.getFullName(), Messages.ToolsPaths_ToolchainName_label, (Composite)group);
            labelField.fillIntoGrid((Composite)group, 4);
            this.addField((FieldEditor)labelField);
            boolean isStrict = this.fDefaultPreferences.getBoolean("project.toolchain.path.strict", true);
            String[] xpackNames = this.fDefaultPreferences.getToolchainXpackNames(toolchain.getId(), toolchain.getName());
            String key = PersistentPreferences.getToolchainKey((String)toolchain.getId(), (String)toolchain.getName());
            XpackDirectoryNotStrictFieldEditor toolchainPathField = new XpackDirectoryNotStrictFieldEditor(xpackNames, key, Messages.ToolchainPaths_label, (Composite)group, isStrict);
            toolchainPathField.fillIntoGrid((Composite)group, 4);
            this.addField((FieldEditor)toolchainPathField);
        }
        Label label = new Label((Composite)group, 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
        label.setLayoutData((Object)layoutData);
        label.setText("");
        Label macOSMessage = new Label((Composite)group, 0);
        layoutData = new GridData(4, 0x1000000, true, false, 4, 1);
        macOSMessage.setLayoutData((Object)layoutData);
        macOSMessage.setText(Messages.SetCrossCommandWizardPage_text);
        group.setLayout((Layout)groupLayout);
    }

    protected void adjustGridLayout() {
    }
}

