/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.render.peripheral;

import ilg.gnumcueclipse.debug.gdbjtag.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.datamodel.SvdEnumeratedValueDMNode;
import ilg.gnumcueclipse.debug.gdbjtag.preferences.PersistentPreferences;
import ilg.gnumcueclipse.debug.gdbjtag.render.peripheral.PeripheralColumnInfo;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterFieldVMNode;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralRegisterVMNode;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralTopVMNode;
import ilg.gnumcueclipse.debug.gdbjtag.viewmodel.peripheral.PeripheralTreeVMNode;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class PeripheralColumnLabelProvider
extends ColumnLabelProvider
implements IPropertyChangeListener {
    private static final String COLOR_PREFIX = "ilg.gnumcueclipse.debug.gdbjtag.peripherals.color.";
    public static final String COLOR_READONLY = "ilg.gnumcueclipse.debug.gdbjtag.peripherals.color.readonly";
    public static final String COLOR_WRITEONLY = "ilg.gnumcueclipse.debug.gdbjtag.peripherals.color.writeonly";
    public static final String COLOR_CHANGED = "ilg.gnumcueclipse.debug.gdbjtag.peripherals.color.changed";
    public static final String COLOR_CHANGED_MEDIUM = "ilg.gnumcueclipse.debug.gdbjtag.peripherals.color.changed.medium";
    public static final String COLOR_CHANGED_LIGHT = "ilg.gnumcueclipse.debug.gdbjtag.peripherals.color.changed.light";
    private Color fColorReadOnlyBackground;
    private Color fColorWriteOnlyBackground;
    private Color fColorChangedBackground;
    private Color fColorChangedMediumBackground;
    private Color fColorChangedLightBackground;
    private PeripheralColumnInfo.ColumnType fColumnType;
    private TreeViewer fViewer;
    private boolean fUseFadingBackground;

    public PeripheralColumnLabelProvider(TreeViewer viewer, IMemoryBlockExtension fMemoryBlock, PeripheralColumnInfo.ColumnType type) {
        this.fViewer = viewer;
        this.fColumnType = type;
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setupColors();
        PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
        this.fUseFadingBackground = fPersistentPreferences.getPeripheralsChangedUseFadingBackground();
    }

    public void dispose() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String str = event.getProperty();
        if (str.startsWith(COLOR_PREFIX)) {
            this.setupColors();
            this.fViewer.refresh();
        }
    }

    private void setupColors() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme theme = themeManager.getCurrentTheme();
        ColorRegistry colorRegistry = theme.getColorRegistry();
        this.fColorReadOnlyBackground = colorRegistry.get(COLOR_READONLY);
        this.fColorWriteOnlyBackground = colorRegistry.get(COLOR_WRITEONLY);
        this.fColorChangedBackground = colorRegistry.get(COLOR_CHANGED);
        this.fColorChangedMediumBackground = colorRegistry.get(COLOR_CHANGED_MEDIUM);
        this.fColorChangedLightBackground = colorRegistry.get(COLOR_CHANGED_LIGHT);
    }

    public Color getBackground(Object element) {
        Color color = null;
        boolean isReadOnly = false;
        boolean isWriteOnly = false;
        boolean isReadAllowed = true;
        boolean hasChanged = false;
        int fadingLevel = 0;
        if (element instanceof PeripheralTreeVMNode) {
            PeripheralTreeVMNode node = (PeripheralTreeVMNode)element;
            if (!node.isPeripheral()) {
                isReadOnly = node.isReadOnly();
                isWriteOnly = node.isWriteOnly();
                isReadAllowed = node.isReadAllowed();
            }
            if (node.isRegister() || node.isField()) {
                try {
                    hasChanged = node.hasValueChanged();
                }
                catch (DebugException debugException) {}
            }
            fadingLevel = node.getFadingLevel();
        }
        if (isWriteOnly || !isReadAllowed) {
            color = this.fColorWriteOnlyBackground;
        } else if (isReadOnly) {
            color = this.fColorReadOnlyBackground;
        }
        if (this.fUseFadingBackground) {
            if (fadingLevel == 3) {
                color = this.fColorChangedBackground;
            } else if (fadingLevel == 2) {
                color = this.fColorChangedMediumBackground;
            } else if (fadingLevel == 1) {
                color = this.fColorChangedLightBackground;
            }
        } else if (hasChanged) {
            color = this.fColorChangedBackground;
        }
        return color;
    }

    public Font getFont(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Image getImage(Object element) {
        if (this.fColumnType == PeripheralColumnInfo.ColumnType.REGISTER && element instanceof PeripheralTreeVMNode) {
            String name = ((PeripheralTreeVMNode)element).getImageName();
            return Activator.getInstance().getImage(name);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof PeripheralTreeVMNode) {
            PeripheralTreeVMNode treeNode = (PeripheralTreeVMNode)element;
            switch (this.fColumnType) {
                case REGISTER: {
                    try {
                        String str = " " + treeNode.getName();
                        return str;
                    }
                    catch (DebugException debugException) {}
                }
                case ADDRESS: {
                    return treeNode.getDisplayAddress();
                }
                case VALUE: {
                    return treeNode.getDisplayValue();
                }
            }
        }
        return null;
    }

    public String getToolTipText(Object element) {
        StringBuilder sb = new StringBuilder();
        if (element instanceof PeripheralTreeVMNode) {
            PeripheralTreeVMNode treeNode = (PeripheralTreeVMNode)element;
            sb.append(treeNode.getDisplayNodeType());
            switch (this.fColumnType) {
                case REGISTER: {
                    try {
                        this.appendText(sb, "", treeNode.getName());
                    }
                    catch (DebugException debugException) {}
                    String description = "\"" + treeNode.getDescription() + "\"";
                    this.appendText(sb, "", description);
                    if (!(treeNode instanceof PeripheralTopVMNode)) break;
                    this.appendText(sb, "Version=", ((PeripheralTopVMNode)treeNode).getDisplayVersion());
                    this.appendText(sb, "Group=", ((PeripheralTopVMNode)treeNode).getDisplayGroupName());
                    break;
                }
                case ADDRESS: {
                    if (treeNode.isField()) {
                        this.appendText(sb, "Range=", treeNode.getDisplayOffset());
                    } else {
                        this.appendText(sb, "Offset=", treeNode.getDisplayOffset());
                    }
                    this.appendText(sb, "Size=", treeNode.getDisplaySize());
                    break;
                }
                case VALUE: {
                    if (treeNode.isPeripheral() || treeNode.isCluster()) {
                        return null;
                    }
                    if (treeNode instanceof PeripheralRegisterVMNode) {
                        this.appendText(sb, "Reset=", ((PeripheralRegisterVMNode)treeNode).getDisplayResetValue());
                        break;
                    }
                    if (!(treeNode instanceof PeripheralRegisterVMNode)) break;
                    this.appendText(sb, "Reset=", ((PeripheralRegisterFieldVMNode)treeNode).getDisplayResetValue());
                    break;
                }
            }
            this.appendText(sb, "", this.getDisplayAccess(treeNode));
            this.appendText(sb, "", this.getDisplayReadAction(treeNode));
            switch (this.fColumnType) {
                case VALUE: {
                    SvdEnumeratedValueDMNode node;
                    if (!(treeNode instanceof PeripheralRegisterFieldVMNode) || !((PeripheralRegisterFieldVMNode)treeNode).isEnumeration() || (node = ((PeripheralRegisterFieldVMNode)treeNode).getEnumeratedValueDMNode()) == null) break;
                    this.appendText(sb, "Enumeration=", "\"" + node.getDescription() + "\"");
                    break;
                }
            }
        }
        if (sb.length() != 0) {
            return sb.toString();
        }
        return null;
    }

    public String getDisplayAccess(PeripheralTreeVMNode element) {
        String str = element.getAccess();
        if ("read-only".equals(str) || "r".equals(str)) {
            return "Read only";
        }
        if ("write-only".equals(str) || "w".equals(str)) {
            return "Write only";
        }
        if ("read-write".equals(str) || "rw".equals(str)) {
            return "Read/Write";
        }
        if ("writeOnce".equals(str)) {
            return "Write once";
        }
        if ("read-writeOnce".equals(str)) {
            return "Read/Write once";
        }
        return "";
    }

    public String getDisplayReadAction(PeripheralTreeVMNode element) {
        String str = element.getReadAction();
        return str;
    }

    private void appendText(StringBuilder sb, String name, String value) {
        if (value == null || value.trim().isEmpty()) {
            return;
        }
        if (sb.length() > 0) {
            if (sb.indexOf(":") == -1) {
                sb.append(": ");
            } else {
                sb.append(", ");
            }
        }
        sb.append(name);
        sb.append(value.trim());
    }
}

