/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.managedbuild.cross.riscv.ui.preferences;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.core.preferences.ScopedPreferenceStoreWithoutDefaults;
import ilg.gnumcueclipse.core.ui.LabelFakeFieldEditor;
import ilg.gnumcueclipse.core.ui.XpackDirectoryNotStrictFieldEditor;
import ilg.gnumcueclipse.managedbuild.cross.preferences.DefaultPreferences;
import ilg.gnumcueclipse.managedbuild.cross.preferences.PersistentPreferences;
import ilg.gnumcueclipse.managedbuild.cross.riscv.Activator;
import ilg.gnumcueclipse.managedbuild.cross.riscv.Option;
import ilg.gnumcueclipse.managedbuild.cross.riscv.ui.Messages;
import ilg.gnumcueclipse.managedbuild.cross.riscv.ui.preferences.ToolchainsFieldEditor;
import java.util.HashSet;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkspaceToolchainsPathsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ilg.gnumcueclipse.managedbuild.cross.riscv.preferencePage.workspaceToolchainsPaths";
    private PersistentPreferences fPersistentPreferences = Activator.getInstance().getPersistentPreferences();
    private DefaultPreferences fDefaultPreferences = new DefaultPreferences("ilg.gnumcueclipse.managedbuild.cross.riscv");

    public WorkspaceToolchainsPathsPreferencesPage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStoreWithoutDefaults(InstanceScope.INSTANCE, "ilg.gnumcueclipse.managedbuild.cross.riscv"));
        this.setDescription(Messages.WorkspaceToolchainsPathsPreferencesPage_description);
    }

    public void init(IWorkbench workbench) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("riscv.WorkspaceToolchainsPathsPreferencesPage.init()");
        }
    }

    protected void createFieldEditors() {
        ToolchainsFieldEditor toolchainNameField = new ToolchainsFieldEditor("toolchain.name", Messages.ToolchainName_label, this.getFieldEditorParent());
        this.addField((FieldEditor)toolchainNameField);
        HashSet<String> toolchainNames = new HashSet<String>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IConfiguration[] configs = EclipseUtils.getConfigurationsForProject((IProject)projects[i]);
            if (configs != null) {
                int j = 0;
                while (j < configs.length) {
                    IOption option;
                    IToolChain toolchain = configs[j].getToolChain();
                    if (toolchain != null && (option = toolchain.getOptionBySuperClassId(Option.OPTION_TOOLCHAIN_NAME)) != null) {
                        try {
                            String name = option.getStringValue();
                            if (!name.isEmpty()) {
                                toolchainNames.add(name);
                            }
                        }
                        catch (BuildException buildException) {}
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (toolchainNames.isEmpty()) {
            toolchainNames.add(this.fPersistentPreferences.getToolchainName());
        }
        for (String toolchainName : toolchainNames) {
            LabelFakeFieldEditor labelField = new LabelFakeFieldEditor(toolchainName, Messages.ToolsPaths_ToolchainName_label, this.getFieldEditorParent());
            this.addField((FieldEditor)labelField);
            boolean isStrict = this.fDefaultPreferences.getBoolean("workspace.toolchain.path.strict", true);
            String[] xpackNames = this.fDefaultPreferences.getToolchainXpackNames(toolchainName);
            String key = PersistentPreferences.getToolchainKey((String)toolchainName);
            XpackDirectoryNotStrictFieldEditor toolchainPathField = new XpackDirectoryNotStrictFieldEditor(xpackNames, key, Messages.ToolchainPaths_label, this.getFieldEditorParent(), isStrict);
            this.addField((FieldEditor)toolchainPathField);
        }
    }
}

