/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.jlink.dsf;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.core.StringUtils;
import ilg.gnumcueclipse.debug.gdbjtag.DebugUtils;
import ilg.gnumcueclipse.debug.gdbjtag.dsf.GnuMcuDebuggerCommandsService;
import ilg.gnumcueclipse.debug.gdbjtag.jlink.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.jlink.preferences.DefaultPreferences;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class DebuggerCommands
extends GnuMcuDebuggerCommandsService {
    private DefaultPreferences fDefaultPreferences = Activator.getInstance().getDefaultPreferences();

    public DebuggerCommands(DsfSession session, ILaunchConfiguration lc, String mode) {
        super(session, lc, mode, true);
    }

    protected BundleContext getBundleContext() {
        return Activator.getInstance().getBundle().getBundleContext();
    }

    public IStatus addGdbInitCommandsCommands(List<String> commandsList) {
        String otherInits = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbClientOtherCommands", (Object)this.fDefaultPreferences.getGdbClientCommands())).trim();
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        return Status.OK_STATUS;
    }

    public IStatus addGnuMcuResetCommands(List<String> commandsList) {
        IStatus status = this.addFirstResetCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        status = this.addLoadSymbolsCommands(commandsList);
        if (!status.isOK()) {
            return status;
        }
        boolean doConnectToRunning = (Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.doConnectToRunning", (Object)false);
        if (!doConnectToRunning && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue() && !((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.doDebugInRam", (Object)this.fDefaultPreferences.getJLinkDebugInRam())).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addGnuMcuStartCommands(List<String> commandsList) {
        boolean doReset = (Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.doConnectToRunning", (Object)false) == false;
        IStatus status = this.addStartRestartCommands(doReset, commandsList);
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    public IStatus addGnuMcuRestartCommands(List<String> commandsList) {
        return this.addStartRestartCommands(true, commandsList);
    }

    public IStatus addFirstResetCommands(List<String> commandsList) {
        String commandStr;
        boolean noReset;
        String attr;
        try {
            attr = String.valueOf(CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.firstResetSpeed", (Object)this.fDefaultPreferences.getJLinkInitialResetSpeed()));
        }
        catch (Exception exception) {
            attr = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.firstResetSpeed", (Object)String.valueOf(this.fDefaultPreferences.getJLinkInitialResetSpeed()));
        }
        if (!attr.isEmpty()) {
            commandsList.add("monitor speed " + attr);
        }
        if (!(noReset = ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.doConnectToRunning", (Object)false)).booleanValue()) && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.doFirstReset", (Object)this.fDefaultPreferences.getJLinkDoInitialReset())).booleanValue()) {
            commandStr = "monitor clrbp";
            commandsList.add(commandStr);
            commandStr = "monitor reset ";
            String resetType = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.firstResetType", (Object)this.fDefaultPreferences.getJLinkInitialResetType());
            commandsList.add(String.valueOf(commandStr) + resetType);
            commandStr = "monitor halt";
            commandsList.add(commandStr);
            commandStr = "monitor regs";
            commandsList.add(commandStr);
            commandStr = "flushreg";
            commandsList.add(commandStr);
        }
        if ("auto".equals(attr = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.interfaceSpeed", (Object)"auto"))) {
            commandsList.add("monitor speed auto");
        } else if ("adaptive".equals(attr)) {
            commandsList.add("monitor speed adaptive");
        } else {
            commandsList.add("monitor speed " + attr);
        }
        commandStr = "monitor flash breakpoints ";
        commandStr = (Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.enableFlashBreakpoints", (Object)this.fDefaultPreferences.getJLinkEnableFlashBreakpoints()) != false ? String.valueOf(commandStr) + "1" : String.valueOf(commandStr) + "0";
        commandsList.add(commandStr);
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.enableSemihosting", (Object)this.fDefaultPreferences.getJLinkEnableSemihosting())).booleanValue()) {
            commandStr = "monitor semihosting enable";
            commandsList.add(commandStr);
            int ioclientMask = 0;
            if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.enableSemihostingIoclientTelnet", (Object)this.fDefaultPreferences.getJLinkSemihostingTelnet())).booleanValue()) {
                ioclientMask |= 1;
            }
            if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.enableSemihostingIoclientGdbClient", (Object)this.fDefaultPreferences.getJLinkSemihostingClient())).booleanValue()) {
                ioclientMask |= 2;
            }
            commandStr = "monitor semihosting IOClient " + String.valueOf(ioclientMask);
            commandsList.add(commandStr);
        }
        if ("swd".equals(attr = (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.gdbServerDebugInterface", (Object)"swd")) && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.enableSwo", (Object)this.fDefaultPreferences.getJLinkEnableSwo())).booleanValue()) {
            commandsList.add("monitor SWO DisableTarget 0xFFFFFFFF");
            commandStr = "monitor SWO EnableTarget ";
            commandStr = String.valueOf(commandStr) + CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.swoEnableTargetCpuFreq", (Object)this.fDefaultPreferences.getJLinkSwoEnableTargetCpuFreq());
            commandStr = String.valueOf(commandStr) + " ";
            commandStr = String.valueOf(commandStr) + CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.swoEnableTargetSwoFreq", (Object)this.fDefaultPreferences.getJLinkSwoEnableTargetSwoFreq());
            commandStr = String.valueOf(commandStr) + " ";
            commandStr = String.valueOf(commandStr) + (String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.swoEnableTargetPortMask", (Object)this.fDefaultPreferences.getJLinkSwoEnableTargetPortMask());
            commandStr = String.valueOf(commandStr) + " 0";
            commandsList.add(commandStr);
        }
        String otherInits = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.otherInitCommands", (Object)this.fDefaultPreferences.getJLinkInitOther())).trim();
        otherInits = DebugUtils.resolveAll((String)otherInits, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            otherInits = StringUtils.duplicateBackslashes((String)otherInits);
        }
        DebugUtils.addMultiLine((String)otherInits, commandsList);
        return Status.OK_STATUS;
    }

    public IStatus addStartRestartCommands(boolean doReset, List<String> commandsList) {
        IStatus status;
        String commandStr;
        if (doReset && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.doSecondReset", (Object)this.fDefaultPreferences.getJLinkDoPreRunReset())).booleanValue()) {
            commandStr = "monitor clrbp";
            commandsList.add(commandStr);
            commandStr = "monitor reset ";
            String resetType = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.secondResetType", (Object)this.fDefaultPreferences.getJLinkPreRunResetType())).trim();
            commandsList.add(String.valueOf(commandStr) + resetType);
            commandStr = "monitor halt";
            commandsList.add(commandStr);
        }
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"org.eclipse.cdt.debug.gdbjtag.core.loadImage", (Object)true)).booleanValue() && ((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.doDebugInRam", (Object)this.fDefaultPreferences.getJLinkDebugInRam())).booleanValue() && !(status = this.addLoadImageCommands(commandsList)).isOK()) {
            return status;
        }
        String userCmd = ((String)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.otherRunCommands", (Object)this.fDefaultPreferences.getJLinkPreRunOther())).trim();
        userCmd = DebugUtils.resolveAll((String)userCmd, (Map)this.fAttributes);
        if (this.fDoDoubleBackslash && EclipseUtils.isWindows()) {
            userCmd = StringUtils.duplicateBackslashes((String)userCmd);
        }
        DebugUtils.addMultiLine((String)userCmd, commandsList);
        this.addSetPcCommands(commandsList);
        this.addStopAtCommands(commandsList);
        commandStr = "monitor regs";
        commandsList.add(commandStr);
        commandStr = "flushreg";
        commandsList.add(commandStr);
        if (((Boolean)CDebugUtils.getAttribute((Map)this.fAttributes, (String)"ilg.gnumcueclipse.debug.gdbjtag.jlink.doContinue", (Object)true)).booleanValue()) {
            commandsList.add("continue");
        }
        return Status.OK_STATUS;
    }
}

