/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.core.ui;

import ilg.gnumcueclipse.core.Activator;
import ilg.gnumcueclipse.core.EclipseUtils;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class StringVariableFieldEditor
extends StringFieldEditor {
    protected String fVariableName;
    protected String fVariableDescription;

    public StringVariableFieldEditor(String name, String variableName, String variableDescription, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.fVariableName = variableName;
        this.fVariableDescription = variableDescription;
    }

    protected void doLoad() {
        if (this.getTextControl() != null) {
            String value = EclipseUtils.getVariableValue(this.fVariableName);
            if (value == null || value.isEmpty()) {
                value = this.getPreferenceStore().getString(this.getPreferenceName());
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("StringVariableFieldEditor.doLoad() got \"" + value + "\"");
                }
                this.setPresentsDefaultValue(false);
            }
            this.getTextControl().setText(value);
            this.oldValue = value;
        }
    }

    protected void doStore() {
        String value = this.getTextControl().getText();
        EclipseUtils.setVariableValue(this.fVariableName, this.fVariableDescription, value);
        super.doStore();
    }
}

