/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.openocd.core.dsf;

import java.io.File;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.dsf.GnuMcuGdbBackend;
import org.eclipse.embedcdt.debug.gdbjtag.openocd.core.Configuration;
import org.eclipse.embedcdt.internal.debug.gdbjtag.openocd.core.Activator;

public class GdbBackend
extends GnuMcuGdbBackend {
    private final ILaunchConfiguration fLaunchConfiguration;

    public GdbBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbBackend() " + (Object)((Object)this));
        }
        this.fLaunchConfiguration = lc;
    }

    public void initialize(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbBackend.initialize() " + Thread.currentThread());
        }
        super.initialize(rm);
    }

    public void destroy() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbBackend.destroy() " + Thread.currentThread());
        }
        super.destroy();
    }

    public void shutdown(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbBackend.shutdown() " + Thread.currentThread());
        }
        super.shutdown(rm);
    }

    protected String[] getGDBCommandLineArray() {
        String[] commandLineArray = Configuration.getGdbClientCommandLineArray(this.fLaunchConfiguration);
        return commandLineArray;
    }

    protected Process launchGDBProcess(String[] commandLineArray) throws CoreException {
        File dir = null;
        IPath path = this.getGDBWorkingDirectory();
        if (path != null) {
            dir = new File(path.toOSString());
        }
        Process proc = DebugUtils.exec((String[])commandLineArray, (String[])DebugUtils.getLaunchEnvironment((ILaunchConfiguration)this.fLaunchConfiguration), (File)dir);
        return proc;
    }

    public IPath getGDBWorkingDirectory() throws CoreException {
        IPath path;
        try {
            path = super.getGDBWorkingDirectory();
        }
        catch (CoreException coreException) {
            path = null;
        }
        if (path == null) {
            path = DebugUtils.getProjectOsPath((ILaunchConfiguration)this.fLaunchConfiguration);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("openocd.GdbBackend.getGDBWorkingDirectory() " + path);
        }
        return path;
    }
}

