/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.data;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.embedcdt.debug.core.data.ISVDPathManager;
import org.eclipse.embedcdt.debug.core.data.ISVDPathManagerFactory;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;

public class SVDPathManagerProxy
implements ISVDPathManager {
    private static final String FACTORY_ELEMENT = "factory";
    private static final String CLASS_ATTRIBUTE = "class";
    private static SVDPathManagerProxy fgInstance;
    private ISVDPathManager[] fPathManagers;

    public static SVDPathManagerProxy getInstance() {
        if (fgInstance == null) {
            fgInstance = new SVDPathManagerProxy();
        }
        return fgInstance;
    }

    public SVDPathManagerProxy() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.embedcdt.debug.core.svdPath");
        if (extensionPoint == null) {
            Activator.log((String)"Extension point org.eclipse.embedcdt.debug.core.svdPath not found");
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length == 0) {
            Activator.log((String)"Extension point org.eclipse.embedcdt.debug.core.svdPath has no extensions");
            return;
        }
        this.fPathManagers = new ISVDPathManager[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            block8: {
                this.fPathManagers[i] = null;
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                IConfigurationElement configElement = configElements[0];
                if (FACTORY_ELEMENT.equals(configElement.getName())) {
                    try {
                        Object obj = configElement.createExecutableExtension(CLASS_ATTRIBUTE);
                        if (obj instanceof ISVDPathManagerFactory) {
                            ISVDPathManagerFactory factory = (ISVDPathManagerFactory)obj;
                            this.fPathManagers[i] = factory.create();
                            break block8;
                        }
                        Activator.log((String)"no ISVDPathManagerFactory");
                    }
                    catch (CoreException coreException) {
                        Activator.log((String)"cannot get factory for org.eclipse.embedcdt.debug.core.svdPath");
                    }
                } else {
                    Activator.log((String)"no <factory> element");
                }
            }
            ++i;
        }
    }

    public IPath getSVDAbsolutePath(String deviceVendorId, String deviceName) {
        if (this.fPathManagers == null) {
            return null;
        }
        int i = 0;
        while (i < this.fPathManagers.length) {
            IPath path = null;
            if (this.fPathManagers[i] != null && (path = this.fPathManagers[i].getSVDAbsolutePath(deviceVendorId, deviceName)) != null) {
                return path;
            }
            ++i;
        }
        return null;
    }
}

