/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.datamodel;

import java.math.BigInteger;
import java.util.LinkedList;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdObjectDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdUtils;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;
import org.eclipse.embedcdt.packs.core.tree.Leaf;

public class SvdDMNode
extends SvdObjectDMNode
implements Comparable<SvdDMNode> {
    private String fAccess = null;
    private String fReadAction = null;
    private BigInteger fBigArrayAddressIncrement = null;

    public SvdDMNode(Leaf node) {
        super(node);
    }

    @Override
    public void dispose() {
        this.fAccess = null;
        this.fReadAction = null;
        super.dispose();
    }

    public BigInteger getBigAbsoluteAddress() {
        return null;
    }

    public BigInteger getBigMaxAbsoluteAddress() {
        return null;
    }

    public BigInteger getBigRepeatIncrement() {
        return null;
    }

    public String getAccess() {
        if (this.fAccess == null) {
            this.fAccess = this.getPropertyWithDerivedWithParent("access");
        }
        return this.fAccess;
    }

    public boolean isReadOnly() {
        String access = this.getAccess();
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            return "read-only".equals(access);
        }
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            return "r".equals(access);
        }
        return false;
    }

    public boolean isWriteOnly() {
        String access = this.getAccess();
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            return "write-only".equals(access) || "writeOnce".equals(access);
        }
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            return "w".equals(access);
        }
        return false;
    }

    public boolean hasReadAction() {
        return !this.getReadAction().isEmpty();
    }

    public boolean isReadAllowed() {
        return !this.hasReadAction();
    }

    public int getWidthBits() {
        return -1;
    }

    public BigInteger getBigSizeBytes() {
        return null;
    }

    public BigInteger getBigAddressOffset() {
        return BigInteger.ZERO;
    }

    public String getReadAction() {
        if (this.fReadAction == null) {
            this.fReadAction = this.getPropertyWithDerivedWithParent("readAction");
        }
        return this.fReadAction;
    }

    public boolean isArray() {
        String element = null;
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            element = "dim";
        } else if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            element = "arraySize";
        }
        return !this.getNode().getProperty(element).isEmpty();
    }

    public boolean isRepetition() {
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            return !this.getNode().getProperty("repeatGenerator").isEmpty();
        }
        return false;
    }

    public int getArraySize() {
        int dim;
        String element = null;
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            element = "dim";
        } else if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            element = "arraySize";
        } else {
            return 0;
        }
        String str = this.getNode().getProperty(element);
        try {
            dim = (int)SvdUtils.parseScaledNonNegativeLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            Activator.log((String)("Node " + this.getNode().getName() + ", non integer <" + element + "> " + str));
            dim = 0;
        }
        return dim;
    }

    public BigInteger getBigArrayAddressIncrement() {
        if (this.fBigArrayAddressIncrement == null) {
            String element = null;
            if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
                element = "dimIncrement";
            } else if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
                element = "repeatIncrement";
            }
            String increment = this.getNode().getProperty(element);
            if (increment.isEmpty()) {
                this.fBigArrayAddressIncrement = BigInteger.ZERO;
            } else {
                try {
                    this.fBigArrayAddressIncrement = SvdUtils.parseScaledNonNegativeBigInteger(increment);
                }
                catch (NumberFormatException numberFormatException) {
                    Activator.log((String)("Node " + this.getNode().getName() + ", non number <" + element + "> " + increment));
                    this.fBigArrayAddressIncrement = BigInteger.ZERO;
                }
            }
        }
        return this.fBigArrayAddressIncrement;
    }

    public String[] getRepetitionSubstitutions() {
        LinkedList<String> lst = new LinkedList<String>();
        String element = null;
        if (this.getNode().getPackType() == Leaf.PACK_TYPE_CMSIS) {
            element = "dimIndex";
        } else if (this.getNode().getPackType() == Leaf.PACK_TYPE_XPACK) {
            element = "repeatGenerator";
        }
        String index = this.getNode().getProperty(element);
        if (!index.isEmpty()) {
            if (index.contains("-")) {
                String[] range = index.split("-");
                try {
                    int from = Integer.parseInt(range[0]);
                    int to = Integer.parseInt(range[1]);
                    int i = from;
                    while (i <= to) {
                        lst.add(String.valueOf(i));
                        ++i;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Activator.log((String)("Node " + this.getNode().getName() + ", non number range " + range + ", ignored."));
                }
            } else if (index.contains(",")) {
                String[] indices = index.split(",");
                int i = 0;
                while (i < indices.length) {
                    lst.add(String.valueOf(i));
                    ++i;
                }
            }
        }
        return lst.toArray(new String[0]);
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this.getDisplayName() + ", " + this.getAccess() + "]";
    }

    @Override
    public int compareTo(SvdDMNode comp) {
        return this.getDisplayName().compareTo(comp.getDisplayName());
    }
}

