/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.memory;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.provisional.model.IMemoryBlockUpdatePolicyProvider;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.Addr64Factory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.embedcdt.core.SystemJob;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.PeripheralDMContext;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.PeripheralDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.dsf.GnuMcuCommandFactory;
import org.eclipse.embedcdt.debug.gdbjtag.core.memory.PeripheralMemoryBlockRetrieval;
import org.eclipse.embedcdt.debug.gdbjtag.core.memory.PeripheralMemoryRegion;
import org.eclipse.embedcdt.debug.gdbjtag.core.services.IPeripheralMemoryService;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralGroupVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralRegisterFieldVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralRegisterVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralTopVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralTreeVMNode;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;

public class PeripheralMemoryBlockExtension
extends PlatformObject
implements IMemoryBlockExtension,
IMemoryBlockUpdatePolicyProvider,
IDebugEventSetListener {
    private PeripheralDMNode fPeripheralDMNode;
    private GnuMcuCommandFactory fCommandFactory;
    private ICommandControl fCommandControl;
    private DsfMemoryBlockRetrieval fRetrieval;
    private IMemory.IMemoryDMContext fMemoryDMContext;
    private String fBlockDisplayName;
    private String fModelId;
    private PeripheralTopVMNode fPeripheralTop;
    private ArrayList<Object> fConnections;
    private SystemJob fUpdatePeripheralRenderingJob;
    private PeripheralDMContext fPeripheralDMContext;
    private IPeripheralMemoryService fMemoryService;
    private boolean fIsBigEndian;
    private int fAddressSize = 4;
    private IAddressFactory fAddressFactory;
    private List<PeripheralMemoryRegion> fReadableMemoryRegions;

    public PeripheralMemoryBlockExtension(DsfMemoryBlockRetrieval memoryBlockRetrieval, IMemory.IMemoryDMContext memoryDMContext, String modelId, final PeripheralDMContext peripheralDMContext) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockExtension()");
        }
        this.fUpdatePeripheralRenderingJob = new SystemJob("Update peripheral rendering"){

            protected IStatus run(IProgressMonitor pm) {
                if (PeripheralMemoryBlockExtension.this.fPeripheralTop == null) {
                    return Status.OK_STATUS;
                }
                if (PeripheralMemoryBlockExtension.this.fReadableMemoryRegions == null) {
                    return Status.OK_STATUS;
                }
                try {
                    PeripheralMemoryBlockExtension.this.updatePeripheralRenderingValues();
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("PeripheralMemoryBlockExtension " + PeripheralMemoryBlockExtension.this.fBlockDisplayName + " fireDebugEventSet(changed)");
                    }
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)PeripheralMemoryBlockExtension.this, 16, 512)});
                }
                catch (NullPointerException e) {
                    Activator.log((Throwable)e);
                    return new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", "Update peripheral rendering failed", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        this.fPeripheralDMContext = peripheralDMContext;
        this.fConnections = new ArrayList();
        this.fRetrieval = memoryBlockRetrieval;
        this.fMemoryDMContext = memoryDMContext;
        this.fBlockDisplayName = peripheralDMContext.getName();
        this.fModelId = modelId;
        String sessionId = memoryBlockRetrieval.getSession().getId();
        final DsfServicesTracker tracker = new DsfServicesTracker(Activator.getInstance().getBundle().getBundleContext(), sessionId);
        Query query = new Query(){

            protected void execute(DataRequestMonitor rm) {
                PeripheralMemoryBlockExtension.this.fCommandControl = (ICommandControl)tracker.getService(ICommandControl.class);
                CommandFactory commandFactory = ((IMICommandControl)tracker.getService(IMICommandControl.class)).getCommandFactory();
                if (commandFactory instanceof GnuMcuCommandFactory) {
                    PeripheralMemoryBlockExtension.this.fCommandFactory = (GnuMcuCommandFactory)commandFactory;
                    PeripheralMemoryBlockExtension.this.fPeripheralDMNode = peripheralDMContext.getPeripheralInstance();
                    PeripheralMemoryBlockExtension.this.fPeripheralDMNode.setMemoryBlock(PeripheralMemoryBlockExtension.this);
                } else {
                    Activator.log((String)("Error: unknown command factory:" + commandFactory.getClass().getSimpleName()));
                }
                PeripheralMemoryBlockExtension.this.fMemoryService = (IPeripheralMemoryService)tracker.getService(IPeripheralMemoryService.class);
                if (PeripheralMemoryBlockExtension.this.fMemoryService == null) {
                    Activator.log((String)"Error: cannot get IPeripheralMemoryService");
                }
                rm.done();
            }
        };
        ((PeripheralMemoryBlockRetrieval)this.getMemoryBlockRetrieval()).getExecutor().execute((Runnable)query);
        try {
            query.get();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("memory service data initialised");
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        this.fIsBigEndian = this.fMemoryService.isBigEndian(this.fMemoryDMContext);
        this.fAddressSize = this.fMemoryService.getAddressSize(this.fMemoryDMContext);
        this.fAddressFactory = this.fAddressSize <= 4 ? new Addr32Factory() : new Addr64Factory();
        this.fPeripheralTop = this.createPeripheralGroupNode();
        if (this.fPeripheralTop == null) {
            Activator.log((String)("Cannot create peripheral group " + this.fPeripheralDMNode.getName()));
        }
        this.fReadableMemoryRegions = this.createRegionsList();
        this.scheduleUpdatePeripheralRendering();
        this.addDebugEventListeners();
        tracker.dispose();
    }

    public void dispose() throws DebugException {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockExtension.dispose()");
        }
        this.removeDebugEventListeners();
        this.fCommandControl = null;
        this.fCommandFactory = null;
        this.fMemoryDMContext = null;
        this.fBlockDisplayName = null;
        if (this.fPeripheralTop != null) {
            this.fPeripheralTop.dispose();
            this.fPeripheralTop = null;
        }
        this.fPeripheralDMContext.getPeripheralInstance().setMemoryBlock(null);
        this.fReadableMemoryRegions = null;
        this.fAddressFactory = null;
    }

    private void addDebugEventListeners() {
        try {
            this.fRetrieval.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PeripheralMemoryBlockExtension.this.fRetrieval.getSession().addServiceEventListener((Object)PeripheralMemoryBlockExtension.this, null);
                }
            });
        }
        catch (RejectedExecutionException e) {
            Activator.log((Throwable)e);
        }
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    private void removeDebugEventListeners() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        try {
            this.fRetrieval.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PeripheralMemoryBlockExtension.this.fRetrieval.getSession().removeServiceEventListener((Object)PeripheralMemoryBlockExtension.this);
                }
            });
        }
        catch (RejectedExecutionException e) {
            Activator.log((Throwable)e);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMemory.IMemoryChangedEvent event) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockExtension.eventDispatched(IMemoryChangedEvent) " + this.fBlockDisplayName + " " + event);
        }
        if (((IMemory.IMemoryDMContext)event.getDMContext()).equals(this.fMemoryDMContext)) {
            IAddress[] addresses = event.getAddresses();
            int i = 0;
            while (i < addresses.length) {
                this.handleMemoryChange(addresses[i].getValue());
                ++i;
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent event) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockExtension.eventDispatched(ISuspendedDMEvent) " + this.fBlockDisplayName + " " + event);
        }
        this.scheduleUpdatePeripheralRendering();
    }

    public void handleMemoryChange(BigInteger bigInteger) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockExtension.handleMemoryChange() 0x" + bigInteger.toString(16) + " not used");
        }
    }

    private void scheduleUpdatePeripheralRendering() {
        if (this.fUpdatePeripheralRenderingJob != null) {
            this.fUpdatePeripheralRenderingJob.schedule();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i;
        if (Activator.getInstance().isDebugging()) {
            System.out.print("PeripheralMemoryBlockExtension.handleDebugEvents() " + this.fBlockDisplayName + " " + events.length);
            i = 0;
            while (i < events.length) {
                System.out.print(" " + events[i]);
                ++i;
            }
            System.out.println();
        }
        i = 0;
        while (i < events.length) {
            Object object = events[i].getSource();
            if (events[i].getKind() != 8 && events[i].getKind() != 32) {
                boolean cfr_ignored_0 = object instanceof PeripheralMemoryBlockExtension;
            }
            ++i;
        }
    }

    private PeripheralTopVMNode createPeripheralGroupNode() {
        PeripheralDMNode svdNode = this.fPeripheralDMContext.getPeripheralInstance();
        PeripheralTopVMNode node = new PeripheralTopVMNode(null, svdNode, this);
        return node;
    }

    private List<PeripheralMemoryRegion> createRegionsList() {
        LinkedList<PeripheralMemoryRegion> list = new LinkedList<PeripheralMemoryRegion>();
        this.collectRegistersRecursive(this.fPeripheralTop, list);
        Object[] array = list.toArray(new PeripheralMemoryRegion[list.size()]);
        Arrays.sort(array);
        list = new LinkedList();
        int i = 0;
        while (i < array.length) {
            list.add((PeripheralMemoryRegion)array[i]);
            int j = i + 1;
            while (j < array.length) {
                if (!((PeripheralMemoryRegion)array[i]).isContiguous((PeripheralMemoryRegion)array[j])) {
                    i = j;
                    break;
                }
                ((PeripheralMemoryRegion)array[i]).concatenate((PeripheralMemoryRegion)array[j]);
                ++j;
            }
            if (j != array.length) continue;
        }
        return list;
    }

    private void collectRegistersRecursive(PeripheralTreeVMNode node, List<PeripheralMemoryRegion> list) {
        if (node instanceof PeripheralRegisterVMNode && node.isReadAllowed()) {
            PeripheralMemoryRegion region = new PeripheralMemoryRegion(node.getPeripheralBigAddressOffset().longValue(), node.getBigSize().longValue());
            region.addNode((PeripheralRegisterVMNode)node);
            list.add(region);
            return;
        }
        if (node instanceof PeripheralRegisterFieldVMNode) {
            return;
        }
        if (node.hasChildren()) {
            int i = 0;
            while (i < node.getChildren().length) {
                PeripheralTreeVMNode child = (PeripheralTreeVMNode)node.getChildren()[i];
                this.collectRegistersRecursive(child, list);
                ++i;
            }
        }
    }

    private void readPeripheralMemoryRegions(RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralMemoryBlockExtension.readPeripheralMemoryRegions() " + this.fBlockDisplayName);
        }
        IAddress address = this.getAddressFactory().createAddress(this.fPeripheralTop.getBigAbsoluteAddress());
        DsfExecutor executor = ((PeripheralMemoryBlockRetrieval)this.getMemoryBlockRetrieval()).getExecutor();
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)executor, rm);
        if (this.fReadableMemoryRegions == null) {
            return;
        }
        countingRm.setDoneCount(this.fReadableMemoryRegions.size());
        for (final PeripheralMemoryRegion region : this.fReadableMemoryRegions) {
            DataRequestMonitor<MemoryByte[]> drm = new DataRequestMonitor<MemoryByte[]>((Executor)executor, (RequestMonitor)countingRm){

                protected void handleCompleted() {
                    region.setBytes((MemoryByte[])this.getData());
                    super.handleCompleted();
                }
            };
            this.fMemoryService.getMemory(this.fMemoryDMContext, address, region.getAddressOffset(), 1, (int)region.getSizeBytes(), drm);
        }
    }

    public void updatePeripheralRenderingValues() {
        Query query = new Query(){

            protected void execute(DataRequestMonitor rm) {
                PeripheralMemoryBlockExtension.this.readPeripheralMemoryRegions((RequestMonitor)rm);
            }
        };
        ((PeripheralMemoryBlockRetrieval)this.getMemoryBlockRetrieval()).getExecutor().execute((Runnable)query);
        try {
            query.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        if (this.fReadableMemoryRegions == null) {
            return;
        }
        for (PeripheralMemoryRegion region : this.fReadableMemoryRegions) {
            MemoryByte[] regionBytes = region.getBytes();
            long regionOffset = region.getAddressOffset();
            for (PeripheralRegisterVMNode node : region.getNodes()) {
                long nodeOffset = node.getPeripheralBigAddressOffset().longValue();
                int byteOffset = (int)(nodeOffset - regionOffset);
                int widthBytes = node.getWidthBytes();
                MemoryByte[] bytes = new MemoryByte[widthBytes];
                int i = 0;
                while (i < widthBytes) {
                    bytes[i] = regionBytes[byteOffset + i];
                    ++i;
                }
                BigInteger value = this.prepareBigIntegerFromByteArray(bytes);
                node.setValue(value);
            }
        }
    }

    private byte[] prepareByteArrayFromBigInteger(BigInteger value, int sizeBytes) {
        byte[] buf = new byte[sizeBytes];
        byte[] valueBuf = value.toByteArray();
        if (this.fIsBigEndian) {
            int i = 0;
            while (i < buf.length) {
                buf[buf.length - i - 1] = i < valueBuf.length ? valueBuf[valueBuf.length - i - 1] : (byte)0;
                ++i;
            }
        } else {
            int i = 0;
            while (i < buf.length) {
                buf[i] = i < valueBuf.length ? valueBuf[valueBuf.length - i - 1] : (byte)0;
                ++i;
            }
        }
        return buf;
    }

    private BigInteger prepareBigIntegerFromByteArray(MemoryByte[] bytes) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return BigInteger.ZERO;
        }
        byte[] buf = new byte[bytes.length];
        if (this.fIsBigEndian) {
            i = 0;
            while (i < buf.length) {
                buf[i] = bytes[i].getValue();
                ++i;
            }
        } else {
            i = 0;
            while (i < buf.length) {
                buf[buf.length - i - 1] = bytes[i].getValue();
                ++i;
            }
        }
        BigInteger value = new BigInteger(1, buf);
        return value;
    }

    public void writePeripheralRegister(final long offset, final int sizeBytes, final BigInteger value) {
        Query query = new Query(){

            protected void execute(DataRequestMonitor rm) {
                IAddress address = PeripheralMemoryBlockExtension.this.getAddressFactory().createAddress(PeripheralMemoryBlockExtension.this.fPeripheralTop.getBigAbsoluteAddress());
                byte[] buf = PeripheralMemoryBlockExtension.this.prepareByteArrayFromBigInteger(value, sizeBytes);
                PeripheralMemoryBlockExtension.this.fMemoryService.setMemory(PeripheralMemoryBlockExtension.this.fMemoryDMContext, address, offset, sizeBytes, 1, buf, (RequestMonitor)rm);
            }
        };
        ((PeripheralMemoryBlockRetrieval)this.getMemoryBlockRetrieval()).getExecutor().execute((Runnable)query);
        try {
            query.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
    }

    public BigInteger readPeripheralRegister(final long offset, final int sizeBytes) {
        Query<MemoryByte[]> query = new Query<MemoryByte[]>(){

            protected void execute(DataRequestMonitor<MemoryByte[]> drm) {
                IAddress address = PeripheralMemoryBlockExtension.this.getAddressFactory().createAddress(PeripheralMemoryBlockExtension.this.fPeripheralTop.getBigAbsoluteAddress());
                PeripheralMemoryBlockExtension.this.fMemoryService.getMemory(PeripheralMemoryBlockExtension.this.fMemoryDMContext, address, offset, sizeBytes, 1, drm);
            }
        };
        ((PeripheralMemoryBlockRetrieval)this.getMemoryBlockRetrieval()).getExecutor().execute((Runnable)query);
        BigInteger value = BigInteger.ZERO;
        try {
            MemoryByte[] bytes = (MemoryByte[])query.get();
            value = this.prepareBigIntegerFromByteArray(bytes);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {}
        return value;
    }

    public IAddressFactory getAddressFactory() {
        return this.fAddressFactory;
    }

    public PeripheralGroupVMNode getPeripheralRegisterGroup() {
        return this.fPeripheralTop;
    }

    public PeripheralDMNode getPeripheralInstance() {
        return this.fPeripheralDMNode;
    }

    public long getStartAddress() {
        return this.fPeripheralDMNode.getBigAbsoluteAddress().longValue();
    }

    public long getLength() {
        try {
            return this.getBigLength().longValue();
        }
        catch (DebugException debugException) {
            return 0L;
        }
    }

    public byte[] getBytes() throws DebugException {
        return null;
    }

    public boolean supportsValueModification() {
        return false;
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
    }

    public String getModelIdentifier() {
        return this.fModelId;
    }

    public IDebugTarget getDebugTarget() {
        return this.fRetrieval.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.fRetrieval.getLaunch();
    }

    public String getExpression() {
        return this.fBlockDisplayName;
    }

    public BigInteger getBigBaseAddress() throws DebugException {
        return this.fPeripheralDMNode.getBigAbsoluteAddress();
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return this.fPeripheralDMNode.getBigAbsoluteAddress();
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return this.fPeripheralDMNode.getBigAbsoluteAddress().add(this.getBigLength()).subtract(BigInteger.ONE);
    }

    public BigInteger getBigLength() throws DebugException {
        return this.fPeripheralDMNode.getBigSizeBytes();
    }

    public int getAddressSize() throws DebugException {
        return this.fAddressSize;
    }

    public boolean supportBaseAddressModification() throws DebugException {
        return false;
    }

    public boolean supportsChangeManagement() {
        return false;
    }

    public void setBaseAddress(BigInteger address) throws DebugException {
    }

    public MemoryByte[] getBytesFromOffset(BigInteger unitOffset, long addressableUnits) throws DebugException {
        MemoryByte[] bytes = new MemoryByte[(int)addressableUnits];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = new MemoryByte(0, 0);
            ++i;
        }
        return bytes;
    }

    public MemoryByte[] getBytesFromAddress(BigInteger address, long units) throws DebugException {
        MemoryByte[] bytes = new MemoryByte[(int)units];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = new MemoryByte(0, 0);
            ++i;
        }
        return bytes;
    }

    public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
    }

    public void connect(Object client) {
    }

    public void disconnect(Object client) {
    }

    public Object[] getConnections() {
        return this.fConnections.toArray();
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return this.fRetrieval;
    }

    public int getAddressableSize() throws DebugException {
        return 1;
    }

    public String[] getUpdatePolicies() {
        return null;
    }

    public String getUpdatePolicyDescription(String id) {
        return null;
    }

    public String getUpdatePolicy() {
        return null;
    }

    public void setUpdatePolicy(String id) {
    }

    public void clearCache() {
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IMemoryBlockRetrieval.class)) {
            return this.getMemoryBlockRetrieval();
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return "[" + ((Object)((Object)this)).getClass().getSimpleName() + " " + this.getExpression() + "]";
    }
}

