/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp;

import org.eclipse.embedcdt.core.liqp.parser.Flavor;

public class ParseSettings {
    public final Flavor flavor;
    public final boolean stripSpacesAroundTags;

    private ParseSettings(Flavor flavor, boolean stripSpacesAroundTags) {
        this.flavor = flavor;
        this.stripSpacesAroundTags = stripSpacesAroundTags;
    }

    public static class Builder {
        Flavor flavor = Flavor.LIQUID;
        boolean stripSpacesAroundTags = false;

        public Builder withFlavor(Flavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public Builder withStripSpaceAroundTags(boolean stripSpacesAroundTags) {
            this.stripSpacesAroundTags = stripSpacesAroundTags;
            return this;
        }

        public ParseSettings build() {
            return new ParseSettings(this.flavor, this.stripSpacesAroundTags);
        }
    }
}

