/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.jstree;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.embedcdt.packs.core.jstree.JsNode;

public class JsArray
extends JsNode {
    private ArrayList<Object> fElements;
    private ArrayList<JsNode> fChildren;

    public JsArray() {
        this.fElements = new ArrayList();
        this.fChildren = new ArrayList();
    }

    public JsArray(int initialSize) {
        this.fElements = new ArrayList(initialSize);
        this.fChildren = new ArrayList();
    }

    public ArrayList<Object> getElements() {
        return this.fElements;
    }

    @Override
    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    @Override
    public Collection<JsNode> getChildren() {
        return this.fChildren;
    }

    @Override
    public JsNode getFirstChild() {
        assert (!this.fChildren.isEmpty());
        return this.fChildren.get(0);
    }

    @Override
    protected JsNode getNextSibling(JsNode node) {
        int index = this.fChildren.indexOf(node);
        assert (index >= 0);
        if (++index >= this.fChildren.size()) {
            return null;
        }
        return this.fChildren.get(index);
    }

    public int size() {
        return this.fElements.size();
    }

    public boolean isEmpty() {
        return this.fElements.isEmpty();
    }

    public boolean add(String element) {
        return this.fElements.add(element);
    }

    public boolean add(JsNode element) {
        element.setParent(this);
        this.fChildren.add(element);
        return this.fElements.add(element);
    }

    public boolean add(Object element) {
        if (element instanceof String) {
            return this.add((String)element);
        }
        if (element instanceof JsNode) {
            return this.add((JsNode)element);
        }
        assert (false) : "Unsupported element type " + element.getClass().getName();
        return false;
    }

    public void add(int index, String element) {
        this.fElements.add(index, element);
    }

    public void add(int index, JsNode element) {
        element.setParent(this);
        this.fChildren.add(element);
        this.fElements.add(index, element);
    }

    public Object get(int index) {
        return this.fElements.get(index);
    }

    public Object remove(int index) {
        Object element = this.fElements.remove(index);
        if (element != null && element instanceof JsNode) {
            ((JsNode)element).setParent(null);
            this.fChildren.remove(element);
        }
        return element;
    }

    public Object remove(Object o) {
        Boolean element = this.fElements.remove(o);
        if (element != null && element instanceof JsNode) {
            ((JsNode)((Object)element)).setParent(null);
            this.fChildren.remove(element);
        }
        return element;
    }

    public void clear() {
        int i = 0;
        while (i < this.fElements.size()) {
            this.remove(i);
            ++i;
        }
    }

    public String toString() {
        String str = "[ ";
        boolean first = true;
        String pName = this.getPropertyName();
        if (pName != null) {
            str = String.valueOf(str) + "\"$this\":\"" + pName + "\"";
            first = false;
        }
        for (Object element : this.fElements) {
            if (first) {
                first = false;
            } else {
                str = String.valueOf(str) + ", ";
            }
            str = element instanceof String ? String.valueOf(str) + "\"" + element + "\"" : (element instanceof JsNode ? String.valueOf(str) + element.toString() : String.valueOf(str) + "<" + element.getClass().getSimpleName() + ">");
        }
        str = String.valueOf(str) + " ]";
        return str;
    }

    @Override
    public void serialize(OutputStream o) throws IOException {
        String str = "[";
        boolean first = true;
        for (Object element : this.fElements) {
            if (first) {
                first = false;
            } else {
                str = String.valueOf(str) + ",";
            }
            if (element instanceof String) {
                str = String.valueOf(str) + "\"" + element + "\"";
                o.write(str.getBytes());
                str = "";
                continue;
            }
            if (!(element instanceof JsNode)) continue;
            o.write(str.getBytes());
            str = "";
            ((JsNode)element).serialize(o);
        }
        str = String.valueOf(str) + " ]";
        o.write(str.getBytes());
    }
}

