/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.web.servlets;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.parsley.config.Configurator;
import org.eclipse.emf.parsley.edit.ui.provider.TableViewerContentProvider;
import org.eclipse.emf.parsley.edit.ui.provider.TableViewerContentProviderFactory;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.emf.parsley.ui.provider.FeatureCaptionProvider;
import org.eclipse.emf.parsley.ui.provider.TableFeaturesProvider;
import org.eclipse.emf.parsley.ui.provider.ViewerLabelProvider;
import org.eclipse.emf.parsley.web.servlets.Application;
import org.eclipse.emf.parsley.web.servlets.JsonParsleyServlet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JsonTableServlet
extends JsonParsleyServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Injector injector = Application.getInstance(request).getInjector();
        Configurator configurator = Application.getInstance(request).getConfigurator();
        PrintWriter out = this.prepareOutput(response);
        out.write("[");
        String s = request.getParameter("s");
        System.out.println(s);
        try {
            String partQN = this.getPartQN(s);
            IViewPart viewpartClass = (IViewPart)Class.forName(partQN).newInstance();
            ResourceLoader loader = (ResourceLoader)injector.getInstance(ResourceLoader.class);
            URI uri = configurator.createResourceURI((Object)viewpartClass);
            AdapterFactoryEditingDomain ed = (AdapterFactoryEditingDomain)injector.getProvider(AdapterFactoryEditingDomain.class).get();
            Resource resource = loader.getResource((EditingDomain)ed, uri).getResource();
            ResourceLoader resourceLoader = Application.getInstance(request).getResourceLoader();
            System.out.println(resourceLoader);
            Resource resource1 = resourceLoader.getResource((EditingDomain)ed, uri).getResource();
            System.out.println(resource1);
            FeatureCaptionProvider featureCaptionProvider = (FeatureCaptionProvider)injector.getInstance(FeatureCaptionProvider.class);
            EClass clazz = configurator.getEClass((Object)viewpartClass);
            ViewerLabelProvider labelProvider = (ViewerLabelProvider)injector.getInstance(ILabelProvider.class);
            TableViewerContentProvider tvcp = ((TableViewerContentProviderFactory)injector.getInstance(TableViewerContentProviderFactory.class)).createTableViewerContentProvider(clazz);
            Object[] contents = tvcp.getElements((Object)resource);
            boolean first = true;
            Object[] objectArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                EObject eObject = (EObject)object;
                if (eObject.eClass().equals(clazz)) {
                    String id = Application.getInstance(request).put(eObject);
                    if (!first) {
                        out.write(",");
                    }
                    List features = ((TableFeaturesProvider)injector.getInstance(TableFeaturesProvider.class)).getFeatures(eObject.eClass());
                    String outString = "{\"$id\" : \"" + id + "\", ";
                    for (EStructuralFeature eStructuralFeature : features) {
                        String featureCaption = featureCaptionProvider.getText(clazz, eStructuralFeature);
                        outString = String.valueOf(outString) + "\"" + featureCaption + "\": \"" + labelProvider.getText(eObject.eGet(eStructuralFeature)) + "\",";
                    }
                    outString = outString.substring(0, outString.length() - 1);
                    outString = String.valueOf(outString) + "}";
                    out.write(outString);
                    first = false;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException("Cannot find viewPart with id=\"" + s + "\" in plugin.xml file.");
        }
        out.write("]");
        this.closeOutput(out);
    }

    private String getPartQN(String viewId) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(((Object)((Object)this)).getClass().getResourceAsStream("/plugin.xml"));
        NodeList viewNodes = doc.getElementsByTagName("view");
        int i = 0;
        while (i < viewNodes.getLength()) {
            Node viewNode = viewNodes.item(i);
            NamedNodeMap attrs = viewNode.getAttributes();
            if (viewId.equals(attrs.getNamedItem("id").getNodeValue())) {
                return attrs.getNamedItem("class").getNodeValue().split(":")[1];
            }
            ++i;
        }
        return null;
    }
}

