/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.emfatic.core.generator.emfatic.EmfaticGenerator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class GenerateEmfatic
implements IObjectActionDelegate {
    private IFile _file;
    private volatile GenerateEmfaticJob _job;

    public void setActivePart(IAction iaction, IWorkbenchPart iworkbenchpart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        Object selElem;
        this._file = null;
        if (selection instanceof IStructuredSelection && (selElem = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this._file = (IFile)selElem;
        }
    }

    public void run(IAction action) {
        if (this._file != null && this._job == null) {
            this._job = new GenerateEmfaticJob(this._file);
            this._job.setRule((ISchedulingRule)this._file.getParent());
            this._job.schedule();
        }
    }

    public static boolean ecoreValidate(IFile ecoreFile, IProgressMonitor progressMonitor) {
        String ecoreFilePath = ecoreFile.getFullPath().toString();
        URI uri = URI.createPlatformResourceURI((String)ecoreFilePath, (boolean)false);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource ecoreResource = resourceSet.getResource(uri, true);
        if (ecoreFile != null) {
            progressMonitor.beginTask("ecoreValidating ...", 1);
            EObject rootPackage = (EObject)ecoreResource.getContents().get(0);
            Diagnostician diagnostician = new Diagnostician();
            Diagnostic diagnostic = diagnostician.validate(rootPackage);
            progressMonitor.worked(1);
            if (progressMonitor.isCanceled()) {
                GenerateEmfatic.handleDiagnostic(ecoreFile, Diagnostic.CANCEL_INSTANCE);
            } else {
                GenerateEmfatic.handleDiagnostic(ecoreFile, diagnostic);
            }
            boolean res = diagnostic.getSeverity() < 4;
            return res;
        }
        return false;
    }

    private static void handleDiagnostic(IFile ecoreFile, Diagnostic diagnostic) {
        diagnostic.getSeverity();
        GenerateEmfatic.deleteMarkers((IResource)ecoreFile, false, 0);
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            try {
                GenerateEmfatic.createMarkers((IResource)ecoreFile, childDiagnostic, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static void createMarkers(IResource resource, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
        if (resource != null && resource.exists()) {
            IMarker marker = resource.createMarker(GenerateEmfatic.getMarkerID());
            int severity = diagnostic.getSeverity();
            if (severity < 2) {
                marker.setAttribute("severity", 0);
            } else if (severity < 4) {
                marker.setAttribute("severity", 1);
            } else {
                marker.setAttribute("severity", 2);
            }
            String message = diagnostic.getMessage();
            if (message != null) {
                marker.setAttribute("message", (Object)message);
            }
        }
    }

    protected static String getMarkerID() {
        return "org.eclipse.core.resources.problemmarker";
    }

    protected static void deleteMarkers(IResource resource, boolean includeSubtypes, int depth) {
        if (resource != null && resource.exists()) {
            try {
                resource.deleteMarkers(GenerateEmfatic.getMarkerID(), includeSubtypes, depth);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private class GenerateEmfaticJob
    extends Job {
        private final IFile _file;

        protected IStatus run(IProgressMonitor monitor) {
            boolean ok = GenerateEmfatic.ecoreValidate(this._file, monitor);
            if (ok) {
                EmfaticGenerator generator = new EmfaticGenerator();
                generator.generate(this._file, monitor);
            }
            GenerateEmfatic.this._job = null;
            return Status.OK_STATUS;
        }

        GenerateEmfaticJob(IFile file) {
            super("Generating Emfatic Source for " + file.getName());
            this._file = file;
        }
    }
}

