/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.ui.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfatic.core.lang.gen.ast.BoundExceptWildcard;
import org.eclipse.emf.emfatic.core.lang.gen.ast.CompUnit;
import org.eclipse.emf.emfatic.core.lang.gen.ast.EmfaticASTNode;
import org.eclipse.emf.emfatic.core.lang.gen.ast.TopLevelDecl;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditor;
import org.eclipse.gymnast.runtime.core.ast.ASTNode;
import org.eclipse.gymnast.runtime.core.outline.OutlineNode;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class EmfaticEditorSelectionListener
implements ISelectionChangedListener {
    private EmfaticEditor _editor = null;
    private Annotation[] fOccurrenceAnnotations = null;

    public EmfaticEditorSelectionListener(EmfaticEditor editor) {
        this._editor = editor;
    }

    public void highlightRangeForTopLevelDecl(ITextSelection selection) {
        this._editor.resetHighlightRange();
        ITextSelection ts = selection;
        int offset = ts.getOffset();
        int length = ts.getLength();
        EmfaticASTNode declAtCursor = this._editor.getClosestEnclosingASTNodeAt(offset, length, TopLevelDecl.class);
        if (declAtCursor != null && declAtCursor instanceof TopLevelDecl) {
            this._editor.setHighlightRange(declAtCursor.getRangeStart(), declAtCursor.getRangeLength(), false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            this.highlightRangeForTopLevelDecl(textSelection);
            this.markOccurrences(textSelection);
            this.selectInOutline(textSelection);
        }
    }

    private void selectInOutline(ITextSelection ts) {
        boolean skipSelect;
        int offset = ts.getOffset();
        int length = ts.getLength();
        EmfaticASTNode n = this._editor.getClosestEnclosingASTNodeAt(offset, length, Object.class);
        CompUnit compUnit = (CompUnit)this._editor.getParseRoot();
        if (compUnit == null) {
            return;
        }
        Map a2o = compUnit.getCst2Outline();
        OutlineNode toHighlight = this.findOutlineNodeFor((ASTNode)n, a2o);
        if (toHighlight == null) {
            return;
        }
        ISelection currentOutlineSelection = this._editor.getContentOutlinePage().getSelection();
        OutlineNode selected = null;
        if (currentOutlineSelection instanceof TreeSelection) {
            selected = (OutlineNode)((TreeSelection)currentOutlineSelection).getFirstElement();
        }
        boolean bl = skipSelect = selected == toHighlight;
        if (!skipSelect) {
            this._editor.getContentOutlinePage().selectFromEditor(toHighlight);
        }
    }

    private OutlineNode findOutlineNodeFor(ASTNode n, Map<ASTNode, OutlineNode> a2o) {
        if (a2o == null) {
            return null;
        }
        OutlineNode res = a2o.get(n);
        if (res != null) {
            return res;
        }
        if (n != null && n.getParent() != null) {
            res = this.findOutlineNodeFor(n.getParent(), a2o);
            return res;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markOccurrences(ITextSelection ts) {
        this.removeOccurrenceAnnotations();
        int offset = ts.getOffset();
        int length = ts.getLength();
        BoundExceptWildcard cstUse = (BoundExceptWildcard)this._editor.getClosestEnclosingASTNodeAt(offset, length, BoundExceptWildcard.class);
        if (cstUse == null) {
            return;
        }
        EObject ecoreDecl = (EObject)this._editor.getEcoreDecl2CstUse().getInv((Object)cstUse.getRawTNameOrTVarOrParamzedTName());
        if (ecoreDecl == null) {
            return;
        }
        Set occuNodes = this._editor.getEcoreDecl2CstUse().get((Object)ecoreDecl);
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>();
        for (ASTNode n : occuNodes) {
            String message = "";
            Position pos = new Position(n.getRangeStart(), n.getRangeLength());
            try {
                message = this._editor.getDocument().get(pos.offset, pos.length);
            }
            catch (BadLocationException badLocationException) {
                continue;
            }
            Annotation ann = new Annotation("org.eclipse.jdt.ui.occurrences", false, message);
            annotationMap.put(ann, pos);
        }
        IDocumentProvider documentProvider = this._editor.getDocumentProvider();
        IDocument document = this._editor.getDocument();
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this._editor.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        Object lock = this.getLockObject(document);
        if (lock == null) {
            this.updateAnnotations(annotationModel, annotationMap);
        } else {
            Object object = lock;
            synchronized (object) {
                this.updateAnnotations(annotationModel, annotationMap);
            }
        }
    }

    private void updateAnnotations(IAnnotationModel annotationModel, Map annotationMap) {
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, annotationMap);
        } else {
            this.removeOccurrenceAnnotations();
            for (Map.Entry mapEntry : annotationMap.entrySet()) {
                annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
            }
        }
        this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOccurrenceAnnotations() {
        IDocumentProvider documentProvider = this._editor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this._editor.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)this._editor.getEditorInput());
        Object lock = this.getLockObject(document);
        if (lock == null) {
            this.updateAnnotationModelForRemoves(annotationModel);
        } else {
            Object object = lock;
            synchronized (object) {
                this.updateAnnotationModelForRemoves(annotationModel);
            }
        }
    }

    private void updateAnnotationModelForRemoves(IAnnotationModel annotationModel) {
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
        } else {
            int i = 0;
            int length = this.fOccurrenceAnnotations.length;
            while (i < length) {
                annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                ++i;
            }
        }
        this.fOccurrenceAnnotations = null;
    }

    public void install(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void uninstall(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    private Object getLockObject(IDocument doc) {
        Object lock = null;
        if (doc instanceof ISynchronizable) {
            lock = ((ISynchronizable)doc).getLockObject();
        }
        return lock;
    }
}

