/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerExecutor;
import org.eclipse.emf.emfstore.internal.client.importexport.IExportImportController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.util.EMFStorePreferenceHelper;
import org.eclipse.emf.emfstore.internal.client.ui.util.FileDialogHelper;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIGenericExportImportController
extends AbstractEMFStoreUIController<Void> {
    private final IExportImportController controller;
    private File file;

    public UIGenericExportImportController(Shell shell, IExportImportController controller) {
        super(shell);
        this.controller = controller;
    }

    @Override
    public boolean preRun() {
        this.file = this.selectFile();
        return this.file != null;
    }

    private File selectFile() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String absoluteFilePath = this.controller.isExport() ? FileDialogHelper.openExportDialog(shell, this.controller.getFilename()) : FileDialogHelper.openImportDialog(shell);
        if (absoluteFilePath == null) {
            return null;
        }
        File file = new File(absoluteFilePath);
        return file;
    }

    @Override
    public Void doRun(IProgressMonitor progressMonitor) throws ESException {
        EMFStorePreferenceHelper.setPreference(this.controller.getParentFolderPropertyKey(), this.file.getParent());
        try {
            new ExportImportControllerExecutor(this.file, progressMonitor).execute(this.controller);
            MessageDialog.openInformation((Shell)this.getShell(), (String)(this.controller.isExport() ? Messages.UIGenericExportImportController_ExportImport_Title_0 : String.valueOf(Messages.UIGenericExportImportController_ExportImport_Title_1) + Messages.UIGenericExportImportController_ExportImport_Title_2), (String)MessageFormat.format(Messages.UIGenericExportImportController_ExportImport_Message_0, this.controller.getLabel(), this.controller.isExport() ? Messages.UIGenericExportImportController_ExportImport_Message_1 : Messages.UIGenericExportImportController_ExportImport_Message_2));
        }
        catch (IOException e) {
            EMFStoreMessageDialog.showExceptionDialog(this.getShell(), (Exception)e);
        }
        return null;
    }
}

