/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucket;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictBucketCandidate;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ReservationToConflictBucketCandidateMap;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictDetector {
    public ChangeConflictSet calculateConflicts(List<AbstractChangePackage> myChangePackages, List<AbstractChangePackage> theirChangePackages, Project project) {
        ModelElementIdToEObjectMappingImpl idToEObjectMappingImpl = new ModelElementIdToEObjectMappingImpl((ModelElementIdToEObjectMapping)project, myChangePackages);
        idToEObjectMappingImpl.put(theirChangePackages);
        return this.calculateConflicts(myChangePackages, theirChangePackages, idToEObjectMappingImpl);
    }

    public ChangeConflictSet calculateConflicts(List<AbstractChangePackage> myChangePackages, List<AbstractChangePackage> theirChangePackages, ModelElementIdToEObjectMapping idToEObjectMapping) {
        Set<ConflictBucketCandidate> conflictCandidateBuckets = this.calculateConflictCandidateBuckets(myChangePackages, theirChangePackages, idToEObjectMapping);
        LinkedHashSet<AbstractOperation> notInvolvedInConflict = new LinkedHashSet<AbstractOperation>();
        Set<ConflictBucket> conflictBuckets = this.calculateConflictBucketsFromConflictCandidateBuckets(conflictCandidateBuckets, notInvolvedInConflict);
        return new ChangeConflictSet(conflictBuckets, notInvolvedInConflict, idToEObjectMapping, myChangePackages, theirChangePackages);
    }

    private Set<ConflictBucketCandidate> calculateConflictCandidateBuckets(List<AbstractChangePackage> myChangePackages, List<AbstractChangePackage> theirChangePackages, ModelElementIdToEObjectMapping idToEObjectMapping) {
        List<AbstractOperation> myOperations = this.flattenChangepackages(myChangePackages);
        List<AbstractOperation> theirOperations = this.flattenChangepackages(theirChangePackages);
        return this.calculateConflictCandidateBuckets(idToEObjectMapping, myOperations, theirOperations);
    }

    private Set<ConflictBucketCandidate> calculateConflictCandidateBuckets(ModelElementIdToEObjectMapping idToEObjectMapping, List<AbstractOperation> myOperations, List<AbstractOperation> theirOperations) {
        ReservationToConflictBucketCandidateMap conflictMap = new ReservationToConflictBucketCandidateMap();
        int counter = 0;
        for (AbstractOperation myOperation : myOperations) {
            conflictMap.scanOperationReservations(myOperation, counter, idToEObjectMapping, true);
            ++counter;
        }
        for (AbstractOperation theirOperation : theirOperations) {
            conflictMap.scanOperationReservations(theirOperation, counter, idToEObjectMapping, false);
            ++counter;
        }
        return conflictMap.getConflictBucketCandidates();
    }

    private List<AbstractOperation> flattenChangepackages(List<AbstractChangePackage> changePackages) {
        ArrayList<AbstractOperation> operations = new ArrayList<AbstractOperation>();
        for (AbstractChangePackage changePackage : changePackages) {
            ESCloseableIterable changePackageOperations = changePackage.operations();
            try {
                for (AbstractOperation operation : changePackageOperations.iterable()) {
                    operations.add(operation);
                }
            }
            finally {
                changePackageOperations.close();
            }
        }
        return operations;
    }

    private Set<ConflictBucket> calculateConflictBucketsFromConflictCandidateBuckets(Set<ConflictBucketCandidate> conflictBucketsCandidateSet, Set<AbstractOperation> notInvolvedInConflict) {
        LinkedHashSet<ConflictBucket> conflictBucketsSet = new LinkedHashSet<ConflictBucket>();
        for (ConflictBucketCandidate conflictBucketCandidate : conflictBucketsCandidateSet) {
            Set<ConflictBucket> buckets = conflictBucketCandidate.calculateConflictBuckets(this, notInvolvedInConflict);
            for (ConflictBucket bucket : buckets) {
                conflictBucketsSet.add(bucket);
            }
        }
        return conflictBucketsSet;
    }
}

