/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangePackageSplittingIterator
implements Iterator<ChangePackageEnvelope> {
    private final int changePackageFragmentSize;
    private final FileBasedChangePackage changePackage;
    private int fragmentIndex;
    private int count;
    private ChangePackageEnvelope envelope;
    private boolean isInitialized;

    ChangePackageSplittingIterator(int changePackageFragmentSize, FileBasedChangePackage changePackage) {
        this.changePackageFragmentSize = changePackageFragmentSize;
        this.changePackage = changePackage;
        ModelUtil.logProjectDetails((String)MessageFormat.format("Splitting change package {0}", changePackage.getFilePath()), null, null, null, null, (int)-1);
    }

    @Override
    public boolean hasNext() {
        if (!this.isInitialized) {
            this.init();
        }
        if (this.envelope == null) {
            this.envelope = VersioningFactory.eINSTANCE.createChangePackageEnvelope();
            this.envelope.setFragmentCount(this.count);
        }
        List<String> readLines = this.readLines(this.fragmentIndex * this.changePackageFragmentSize, this.changePackage, this.changePackageFragmentSize);
        this.envelope.getFragment().addAll(readLines);
        this.envelope.setFragmentIndex(this.fragmentIndex);
        if (!this.envelope.getFragment().isEmpty() || this.fragmentIndex == 0) {
            ModelUtil.logProjectDetails((String)MessageFormat.format("Fragment {1} for Change package {0} prepared", this.changePackage.getFilePath(), this.fragmentIndex), null, null, null, null, (int)-1);
            return true;
        }
        ModelUtil.logProjectDetails((String)MessageFormat.format("No more change package fragments for {0}", this.changePackage.getFilePath()), null, null, null, null, (int)-1);
        return false;
    }

    private void init() {
        LineNumberReader lineNumberReader = null;
        try {
            try {
                lineNumberReader = new LineNumberReader(new FileReader(new File(this.changePackage.getTempFilePath())));
                lineNumberReader.skip(Long.MAX_VALUE);
                int lines = lineNumberReader.getLineNumber() + 1;
                this.count = lines / this.changePackageFragmentSize;
                if (lines % this.changePackageFragmentSize != 0) {
                    ++this.count;
                }
            }
            catch (FileNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(lineNumberReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)lineNumberReader);
        this.isInitialized = true;
    }

    private List<String> readLines(int from, FileBasedChangePackage changePackage, int changePackageFragmentSize) {
        int readLines = 0;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            FileReader reader = new FileReader(new File(changePackage.getTempFilePath()));
            LineIterator lineIterator = new LineIterator((Reader)reader);
            int read = 0;
            while (read < from) {
                if (!lineIterator.hasNext()) {
                    return lines;
                }
                lineIterator.next();
                ++read;
            }
            while (readLines < changePackageFragmentSize && lineIterator.hasNext()) {
                String nextLine = lineIterator.next();
                ++readLines;
                lines.add(nextLine);
            }
        }
        catch (FileNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        return lines;
    }

    @Override
    public ChangePackageEnvelope next() {
        boolean hasNext;
        if (this.envelope == null && !(hasNext = this.hasNext())) {
            throw new NoSuchElementException();
        }
        ChangePackageEnvelope ret = this.envelope;
        this.envelope = null;
        ++this.fragmentIndex;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

