/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.backchannel;

import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.connectionmanager.AbstractConnectionManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.xmlrpc.XmlRpcClientManager;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.backchannel.BackchannelInterface;
import org.eclipse.emf.emfstore.server.eventmanager.EMFStoreEventListener;
import org.eclipse.emf.emfstore.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.UnknownSessionException;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.SessionId;
import org.eclipse.emf.emfstore.server.model.versioning.events.server.ServerEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackchannelConnectionManager
extends AbstractConnectionManager<XmlRpcClientManager>
implements BackchannelInterface {
    public void initConnection(ServerInfo serverInfo, SessionId id) throws ConnectionException {
        XmlRpcClientManager clientManager = new XmlRpcClientManager("Backchannel");
        clientManager.initConnection(serverInfo);
        this.addConnectionProxy(id, clientManager);
    }

    public void registerRemoteListener(final SessionId sessionId, final EMFStoreEventListener listener, final ProjectId projectId) throws EmfStoreException {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    while (true) {
                        ServerEvent event;
                        if ((event = (ServerEvent)((XmlRpcClientManager)BackchannelConnectionManager.this.getConnectionProxy(sessionId)).callWithResult("getEvent", ServerEvent.class, new Object[]{sessionId, projectId})) == null) {
                            continue;
                        }
                        listener.handleEvent(event);
                    }
                }
                catch (UnknownSessionException e) {
                    ModelUtil.logException((Throwable)e);
                }
                catch (EmfStoreException e) {
                    ModelUtil.logException((Throwable)e);
                }
            }
        };
        new Thread(runnable).start();
    }

    public void sendEvent(SessionId sessionId, ServerEvent event, ProjectId projectId) throws EmfStoreException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("sendEvent", new Object[]{sessionId, event, projectId});
    }
}

