/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.editor.Activator;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.ecp.editor.mecontrols.IValidatableControl;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public class MERichTextControl
extends AbstractMEControl
implements IValidatableControl {
    private EAttribute attribute;
    private AdapterImpl eAdapter;
    private static final int PRIORITY = 2;
    private Label labelWidgetImage;
    private Composite composite;
    private ToolBar toolBar;
    private Text text;

    public Control createControl(Composite parent, int style) {
        Object feature = this.getItemPropertyDescriptor().getFeature((Object)this.getModelElement());
        this.attribute = (EAttribute)feature;
        this.composite = this.getToolkit().createComposite(parent, style);
        this.composite.setBackgroundMode(2);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(2, 0).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        this.labelWidgetImage = this.getToolkit().createLabel(this.composite, "     ");
        this.labelWidgetImage.setBackground(this.composite.getBackground());
        this.createText();
        this.eAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() != null && msg.getFeature().equals(MERichTextControl.this.attribute)) {
                    MERichTextControl.this.load();
                }
                super.notifyChanged(msg);
            }
        };
        this.getModelElement().eAdapters().add((Object)this.eAdapter);
        this.load();
        return this.composite;
    }

    private void createText() {
        this.text = new Text(this.composite, 2626);
        this.text.setBackground(Display.getCurrent().getSystemColor(1));
        this.text.setSize(10, 100);
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MERichTextControl.this.save();
                super.focusLost(e);
            }
        });
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        spec.heightHint = 200;
        this.text.setLayoutData((Object)spec);
        if (!this.getItemPropertyDescriptor().canSetProperty((Object)this.getModelElement())) {
            this.text.setEnabled(false);
        }
    }

    public ToolBar getToolbar() {
        return this.toolBar;
    }

    private void save() {
        new ECPCommand(this.getModelElement()){

            protected void doRun() {
                MERichTextControl.this.getModelElement().eSet((EStructuralFeature)MERichTextControl.this.attribute, (Object)MERichTextControl.this.text.getText());
            }
        }.run(true);
    }

    private void load() {
        String txt = "";
        final StringBuffer value = new StringBuffer();
        new ECPCommand(this.getModelElement()){

            protected void doRun() {
                if (MERichTextControl.this.getModelElement().eGet((EStructuralFeature)MERichTextControl.this.attribute) == null) {
                    value.append("");
                } else {
                    value.append(MERichTextControl.this.getModelElement().eGet((EStructuralFeature)MERichTextControl.this.attribute));
                }
            }
        }.run(true);
        txt = value.toString();
        this.text.setText(txt);
    }

    public void dispose() {
        this.getModelElement().eAdapters().remove((Object)this.eAdapter);
    }

    public void applyCustomLayoutData() {
        GridDataFactory.fillDefaults().align(4, 128).hint(250, 150).grab(true, false).applyTo((Control)this.composite);
    }

    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement) {
        Object feature = itemPropertyDescriptor.getFeature((Object)modelElement);
        if (feature instanceof EAttribute && ((EAttribute)feature).getEType().getInstanceClass().equals(String.class) && itemPropertyDescriptor.isMultiLine(feature)) {
            return 2;
        }
        return -1;
    }

    public void handleValidation(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            Image image = Activator.getImageDescriptor("icons/validation_error.png").createImage();
            this.labelWidgetImage.setImage(image);
            this.labelWidgetImage.setToolTipText(diagnostic.getMessage());
        }
    }

    public void resetValidation() {
        this.labelWidgetImage.setImage(null);
        this.labelWidgetImage.setToolTipText("");
    }
}

