/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.transaction;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.CommandObserver;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.EMFStoreCommandNotifier;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.EMFStoreCommandStack;
import org.eclipse.emf.emfstore.client.model.util.AbstractEMFStoreCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalCommandStackImpl;

public class EMFStoreTransactionalCommandStack
extends TransactionalCommandStackImpl
implements EMFStoreCommandStack {
    private Command currentCommand;
    private EMFStoreCommandNotifier notifier = new EMFStoreCommandNotifier();

    public void execute(Command command) {
        if (command instanceof AbstractEMFStoreCommand) {
            this.runEMFStoreCommand((AbstractEMFStoreCommand)command);
            return;
        }
        super.execute(command);
    }

    private void runEMFStoreCommand(final AbstractEMFStoreCommand cmd) {
        RecordingCommand recordingCommand = new RecordingCommand((TransactionalEditingDomain)Configuration.getEditingDomain()){

            protected void doExecute() {
                cmd.execute();
            }
        };
        super.execute((Command)recordingCommand);
        if (!cmd.shouldIgnoreExceptions() && cmd.getRuntimeException() != null) {
            throw cmd.getRuntimeException();
        }
    }

    protected void basicExecute(Command command) {
        if (this.currentCommand == null) {
            this.currentCommand = command;
            this.notifier.notifiyListenersAboutStart(command);
        }
        try {
            super.basicExecute(command);
        }
        catch (OperationCanceledException e) {
            this.notifier.notifiyListenersAboutCommandFailed(command, (Exception)((Object)e));
            this.currentCommand = null;
            throw e;
        }
        if (this.currentCommand == command) {
            if (this.mostRecentCommand == command) {
                this.notifier.notifiyListenersAboutCommandCompleted(command);
            }
            this.currentCommand = null;
        }
    }

    protected void handleRollback(Command command, RollbackException rbe) {
        super.handleRollback(command, rbe);
        Object exception = null;
        if (rbe != null) {
            exception = rbe.getCause() != null && rbe.getCause() instanceof Exception ? (Exception)rbe.getCause() : rbe;
        }
        this.notifier.notifiyListenersAboutCommandFailed(command, (Exception)exception);
        if (this.currentCommand == command) {
            this.currentCommand = null;
        }
    }

    public void addCommandStackObserver(CommandObserver observer) {
        this.notifier.addCommandStackObserver(observer);
    }

    public void removeCommandStackObserver(CommandObserver observer) {
        this.notifier.removeCommandStackObserver(observer);
    }
}

