/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.model.util;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.emfstore.common.model.impl.NotifiableIdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;

public class EObjectChangeNotifier
extends EContentAdapter {
    private final NotifiableIdEObjectCollectionImpl collection;
    private boolean isInitializing;
    private Set<EObject> removedModelElements;
    private Stack<Notification> currentNotifications;
    private int reentrantCallToAddAdapterCounter;
    private boolean notificationDisabled;

    public EObjectChangeNotifier(NotifiableIdEObjectCollectionImpl notifiableCollection, Notifier notifier) {
        this.collection = notifiableCollection;
        this.isInitializing = true;
        this.currentNotifications = new Stack();
        notifier.eAdapters().add((Object)this);
        this.isInitializing = false;
        this.reentrantCallToAddAdapterCounter = 0;
        this.notificationDisabled = false;
        this.removedModelElements = new HashSet<EObject>();
    }

    protected void addAdapter(Notifier notifier) {
        EObject modelElement;
        try {
            ++this.reentrantCallToAddAdapterCounter;
            if (!notifier.eAdapters().contains((Object)this)) {
                super.addAdapter(notifier);
            }
        }
        finally {
            --this.reentrantCallToAddAdapterCounter;
        }
        if (this.reentrantCallToAddAdapterCounter > 0 || this.currentNotifications.isEmpty()) {
            return;
        }
        Notification currentNotification = this.currentNotifications.peek();
        if (currentNotification != null && !currentNotification.isTouch() && !this.isInitializing && notifier instanceof EObject && !ModelUtil.isIgnoredDatatype((EObject)notifier) && !this.collection.containsInstance(modelElement = (EObject)notifier) && this.isInCollection(modelElement)) {
            this.collection.modelElementAdded(this.collection, modelElement);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        EObject modelElement;
        EReference eReference;
        if (this.isInitializing || this.currentNotifications.isEmpty()) {
            return;
        }
        Notification currentNotification = this.currentNotifications.peek();
        if (currentNotification != null && currentNotification.isTouch()) {
            return;
        }
        if (currentNotification != null && currentNotification.getFeature() instanceof EReference && (eReference = (EReference)currentNotification.getFeature()).isContainment() && eReference.getEOpposite() != null && !eReference.getEOpposite().isTransient()) {
            return;
        }
        if (notifier instanceof EObject && !this.isInCollection(modelElement = (EObject)notifier) && (this.collection.containsInstance(modelElement) || this.collection.getDeletedModelElementId(modelElement) != null)) {
            this.removedModelElements.add(modelElement);
        }
    }

    private boolean isInCollection(EObject modelElement) {
        EObject parent = modelElement.eContainer();
        if (parent == null) {
            return false;
        }
        if (parent == this.collection) {
            return true;
        }
        if (this.collection.containsInstance(parent)) {
            return true;
        }
        return this.isInCollection(parent);
    }

    public void notifyChanged(Notification notification) {
        if (this.notificationDisabled) {
            return;
        }
        this.currentNotifications.push(notification);
        Object feature = notification.getFeature();
        Object notifier = notification.getNotifier();
        if (feature instanceof EReference) {
            EReference eReference = (EReference)feature;
            if (eReference.isTransient()) {
                return;
            }
            if (eReference.isContainer()) {
                this.handleContainer(notification, eReference);
            }
        }
        super.notifyChanged(notification);
        this.currentNotifications.pop();
        if (!notification.isTouch() && notifier instanceof EObject) {
            this.collection.notify(notification, this.collection, (EObject)notifier);
        }
        for (EObject removedModelElement : this.removedModelElements) {
            this.collection.modelElementRemoved(this.collection, removedModelElement);
        }
        this.removedModelElements.clear();
    }

    private void handleContainer(Notification notification, EReference eReference) {
        if (notification.getEventType() == 1) {
            Object newValue = notification.getNewValue();
            Object oldValue = notification.getOldValue();
            if (newValue == null && oldValue != null) {
                this.removeAdapter((Notifier)notification.getNotifier());
            }
        }
    }

    public void disableNotifications(boolean notificationDisabled) {
        this.notificationDisabled = notificationDisabled;
    }
}

