/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.controller;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.ui.handlers.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.client.ui.util.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.client.ui.views.historybrowserview.HistoryBrowserView;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class UIShowHistoryController
extends AbstractEMFStoreUIController {
    private ProjectSpace projectSpace;
    private final EObject modelElement;

    public UIShowHistoryController(Shell shell, ProjectSpace projectSpace, EObject modelElement) {
        super(shell);
        this.projectSpace = projectSpace;
        this.modelElement = modelElement;
    }

    public void showHistory() throws EmfStoreException {
        if (this.projectSpace == null) {
            this.projectSpace = WorkspaceManager.getInstance().getCurrentWorkspace().getProjectSpace(ModelUtil.getProject((EObject)this.modelElement));
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HistoryBrowserView historyBrowserView = null;
        String viewId = "org.eclipse.emf.emfstore.client.ui.views.historybrowserview.HistoryBrowserView";
        try {
            historyBrowserView = (HistoryBrowserView)page.showView(viewId);
        }
        catch (PartInitException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
        if (historyBrowserView != null) {
            historyBrowserView.setInput(this.projectSpace, this.modelElement);
        }
    }
}

