/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.changeTracking.notification.filter;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.NotificationInfo;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.filter.NotificationFilter;
import org.eclipse.emf.emfstore.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;

public class IgnoreOutsideProjectReferencesFilter
implements NotificationFilter {
    public boolean check(NotificationInfo notificationInfo) {
        ProjectImpl project = (ProjectImpl)ModelUtil.getProject((EObject)notificationInfo.getNotifierModelElement());
        if (project == null) {
            return false;
        }
        if (!notificationInfo.isReferenceNotification()) {
            return false;
        }
        if (!(notificationInfo.getFeature() instanceof EReference)) {
            return false;
        }
        EReference reference = (EReference)notificationInfo.getFeature();
        if (reference.isContainer() || reference.isContainment()) {
            return false;
        }
        if (notificationInfo.getNewValue() != null && notificationInfo.getNewValue() instanceof List) {
            return this.checkNewValueList(notificationInfo, project);
        }
        if (notificationInfo.getOldValue() != null && notificationInfo.getOldValue() instanceof List) {
            return this.checkOldValueList(notificationInfo, project);
        }
        return this.checkSingleReference(notificationInfo, project);
    }

    private boolean checkSingleReference(NotificationInfo notificationInfo, ProjectImpl project) {
        if (notificationInfo.getOldValue() != null && !notificationInfo.isMoveEvent() && this.isOrWasInProject(project, notificationInfo.getOldModelElementValue())) {
            return false;
        }
        return notificationInfo.getNewValue() == null || !this.isOrWasInProject(project, notificationInfo.getNewModelElementValue());
    }

    private boolean checkOldValueList(NotificationInfo notificationInfo, ProjectImpl project) {
        for (EObject referencedElement : (List)notificationInfo.getOldValue()) {
            if (!this.isOrWasInProject(project, referencedElement)) continue;
            return false;
        }
        return true;
    }

    private boolean checkNewValueList(NotificationInfo notificationInfo, ProjectImpl project) {
        for (EObject referencedElement : (List)notificationInfo.getNewValue()) {
            if (!this.isOrWasInProject(project, referencedElement)) continue;
            return false;
        }
        return true;
    }

    private boolean isOrWasInProject(ProjectImpl project, EObject referencedElement) {
        boolean b = project.containsInstance(referencedElement) || project.getDeletedModelElementId(referencedElement) != null;
        return b;
    }
}

