/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.util;

import org.eclipse.emf.emfstore.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.exceptions.InvalidHandleException;
import org.eclipse.emf.emfstore.client.model.exceptions.UnkownProjectException;
import org.eclipse.emf.emfstore.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.server.model.versioning.operations.semantic.SemanticCompositeOperation;

public class SemanticCommand
extends EMFStoreCommand {
    private final Project project;
    private final SemanticCompositeOperation semanticOperation;

    public SemanticCommand(Project project, SemanticCompositeOperation semanticOpertation) {
        if (semanticOpertation.getName() == null || semanticOpertation.getDescription() == null || semanticOpertation.getModelElementId() == null) {
            throw new IllegalArgumentException("Name, description or modelElementId are not set!");
        }
        this.project = project;
        this.semanticOperation = semanticOpertation;
    }

    protected void doRun() {
        Workspace currentWorkspace = WorkspaceManager.getInstance().getCurrentWorkspace();
        try {
            ProjectSpace projectSpace = currentWorkspace.getProjectSpace(this.project);
            CompositeOperationHandle handle = projectSpace.beginCompositeOperation();
            this.semanticOperation.semanticApply(this.project);
            try {
                handle.end(this.semanticOperation);
            }
            catch (InvalidHandleException e) {
                WorkspaceUtil.logException("Semantic command failed because of illegal state of composite operation handle!", e);
            }
        }
        catch (UnkownProjectException e) {
            this.semanticOperation.semanticApply(this.project);
            return;
        }
    }
}

