/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.model;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.model.Activator;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.common.model.PostECPWorkspaceInitiator;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPProject;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPWorkspace;
import org.eclipse.emf.ecp.common.model.workSpaceModel.util.ECPWorkspaceProvider;
import org.eclipse.emf.emfstore.common.observer.ObserverBus;

public final class ECPWorkspaceManager {
    private static ECPWorkspaceManager instance;
    private static ObserverBus observerBus;
    private ECPWorkspace currentWorkspace;

    public static ECPWorkspaceManager getInstance() {
        if (instance == null) {
            instance = new ECPWorkspaceManager();
            instance.init();
            instance.notifyECPPostWorkspaceInitiators();
        }
        return instance;
    }

    private void init() {
        IConfigurationElement[] confs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.model.workspaceprovider");
        if (confs.length == 1) {
            try {
                this.currentWorkspace = ((ECPWorkspaceProvider)confs[0].createExecutableExtension("class")).getECPWorkspace();
            }
            catch (CoreException e) {
                Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
            }
        }
        if (confs.length > 1) {
            try {
                this.currentWorkspace = ((ECPWorkspaceProvider)confs[0].createExecutableExtension("class")).getECPWorkspace();
                IllegalStateException exception = new IllegalStateException("Duplicate Workspace registered. Default selected: " + this.currentWorkspace.getClass().getName() + " Please make sure to only include one Workspace in your target platform.");
                Activator.getDefault().logException(exception.getMessage(), exception);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (confs.length < 1) {
            throw new IllegalStateException("No Workspace registered");
        }
        this.initObserverBus();
    }

    private void initObserverBus() {
        if ("org.eclipse.emf.ecp.emfstorebridge.EMFECPWorkspace".equals(this.currentWorkspace.getClass().getName())) {
            try {
                Method method = this.currentWorkspace.getClass().getMethod("getObserverBus", new Class[0]);
                Object invoke = method.invoke((Object)this.currentWorkspace, new Object[0]);
                if (invoke instanceof ObserverBus) {
                    observerBus = (ObserverBus)invoke;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (observerBus == null) {
            observerBus = new ObserverBus();
        }
    }

    private ECPWorkspaceManager() {
    }

    public ECPWorkspace getWorkSpace() throws NoWorkspaceException {
        if (this.currentWorkspace == null) {
            throw new NoWorkspaceException();
        }
        return this.currentWorkspace;
    }

    public static ECPProject getECPProject(EObject modelElement) {
        try {
            return ECPWorkspaceManager.getInstance().getWorkSpace().getProject(modelElement);
        }
        catch (NoWorkspaceException e) {
            throw new RuntimeException(e);
        }
    }

    public static ObserverBus getObserverBus() {
        ECPWorkspaceManager.getInstance();
        return observerBus;
    }

    private void notifyECPPostWorkspaceInitiators() {
        IConfigurationElement[] workspaceObservers;
        IConfigurationElement[] iConfigurationElementArray = workspaceObservers = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.emf.ecp.model.postinit");
        int n = workspaceObservers.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                PostECPWorkspaceInitiator workspaceObserver = (PostECPWorkspaceInitiator)element.createExecutableExtension("class");
                workspaceObserver.workspaceInitComplete(this.currentWorkspace);
            }
            catch (CoreException e) {
                Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
            }
            ++n2;
        }
    }
}

