/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESWorkspace;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.observer.ESCheckoutObserver;
import org.eclipse.emf.emfstore.client.observer.ESCommitObserver;
import org.eclipse.emf.emfstore.client.observer.ESShareObserver;
import org.eclipse.emf.emfstore.client.observer.ESUpdateObserver;
import org.eclipse.emf.emfstore.client.observer.ESWorkspaceInitObserver;
import org.eclipse.emf.emfstore.client.provider.ESEditingDomainProvider;
import org.eclipse.emf.emfstore.client.sessionprovider.ESAbstractSessionProvider;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ESExtensionPointException;
import org.eclipse.emf.emfstore.internal.client.configuration.FileInfo;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.client.model.ModelPackage;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.commands.EMFStoreBasicCommandStack;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AdminConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.SessionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc.XmlRpcAdminConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc.XmlRpcConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.impl.WorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;
import org.eclipse.emf.emfstore.internal.common.ResourceFactoryRegistry;
import org.eclipse.emf.emfstore.internal.common.model.ModelVersion;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.IResourceLogger;
import org.eclipse.emf.emfstore.internal.common.model.util.MalformedModelVersionException;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.observer.ObserverBus;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigrationException;
import org.eclipse.emf.emfstore.internal.migration.EMFStoreMigratorUtil;
import org.eclipse.emf.emfstore.internal.server.DefaultServerWorkspaceLocationProvider;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ESWorkspaceProviderImpl
implements ESWorkspaceProvider,
ESCommitObserver,
ESUpdateObserver,
ESShareObserver,
ESCheckoutObserver {
    private static ESWorkspaceProviderImpl instance;
    private AdminConnectionManager adminConnectionManager;
    private ConnectionManager connectionManager;
    private EditingDomain editingDomain;
    private ObserverBus observerBus;
    private ResourceSetImpl resourceSet;
    private SessionManager sessionManager;
    private Workspace currentWorkspace;

    public static synchronized ESWorkspaceProviderImpl getInstance() {
        if (instance == null) {
            try {
                instance = new ESWorkspaceProviderImpl();
                instance.initialize();
            }
            catch (RuntimeException e) {
                ModelUtil.logException((String)"Workspace Initialization failed, shutting down", (Throwable)e);
                throw e;
            }
            CommonUtil.getAllModelElementEClasses();
            instance.notifyPostWorkspaceInitiators();
        }
        return instance;
    }

    public static synchronized void init() {
        ESWorkspaceProviderImpl.getInstance();
    }

    public EditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            ESWorkspaceProviderImpl.getInstance();
        }
        return this.editingDomain;
    }

    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    private ESWorkspaceProviderImpl() {
    }

    public void dispose() {
        if (this.currentWorkspace != null) {
            RunESCommand.run(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ((WorkspaceImpl)ESWorkspaceProviderImpl.this.currentWorkspace).dispose();
                    return null;
                }
            });
            this.currentWorkspace = null;
        }
    }

    public boolean isDisposed() {
        return this.currentWorkspace == null;
    }

    public void load() {
        Workspace workspace;
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistry());
        this.resourceSet.setURIResourceMap(new LinkedHashMap());
        this.resourceSet.getLoadOptions().putAll(ModelUtil.getResourceLoadOptions());
        this.setEditingDomain(this.createEditingDomain((ResourceSet)this.resourceSet));
        URI fileURI = URI.createFileURI((String)Configuration.getFileInfo().getWorkspacePath());
        File workspaceFile = new File(Configuration.getFileInfo().getWorkspacePath());
        if (!workspaceFile.exists()) {
            workspace = this.createNewWorkspace((ResourceSet)this.resourceSet, fileURI);
        } else {
            this.migrateModel((ResourceSet)this.resourceSet);
            Resource resource = this.resourceSet.createResource(fileURI);
            try {
                resource.load(ModelUtil.getResourceLoadOptions());
            }
            catch (IOException e) {
                WorkspaceUtil.logException("Error while loading workspace.", e);
            }
            EList directContents = resource.getContents();
            workspace = (Workspace)directContents.get(0);
        }
        workspace.setResourceSet((ResourceSet)this.resourceSet);
        new EMFStoreCommand(){

            protected void doRun() {
                workspace.init();
            }
        }.run(true);
        this.currentWorkspace = workspace;
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this);
    }

    public void flushCommandStack() {
        this.getEditingDomain().getCommandStack().flush();
    }

    public void migrate(String absoluteFilename) {
        URI projectURI = URI.createFileURI((String)absoluteFilename);
        ArrayList<URI> modelURIs = new ArrayList<URI>();
        modelURIs.add(projectURI);
        ModelVersion workspaceModelVersion = this.getWorkspaceModelVersion();
        if (!EMFStoreMigratorUtil.isMigratorAvailable()) {
            ModelUtil.logWarning((String)"No Migrator available to migrate imported file");
            return;
        }
        try {
            EMFStoreMigratorUtil.getEMFStoreMigrator().migrate(modelURIs, workspaceModelVersion.getReleaseNumber() - 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (EMFStoreMigrationException e) {
            WorkspaceUtil.logWarning("The migration of the project in the file " + absoluteFilename + " failed!", (Exception)((Object)e));
        }
    }

    public AdminConnectionManager getAdminConnectionManager() {
        return this.adminConnectionManager;
    }

    public static ProjectSpace getProjectSpace(EObject modelElement) {
        if (modelElement == null) {
            throw new IllegalArgumentException("The model element is null");
        }
        if (modelElement instanceof ProjectSpace) {
            return (ProjectSpace)modelElement;
        }
        Project project = ModelUtil.getProject((EObject)modelElement);
        if (project == null) {
            throw new IllegalArgumentException("The model element " + modelElement + " has no project");
        }
        return ESWorkspaceProviderImpl.getProjectSpace(project);
    }

    public static ProjectSpace getProjectSpace(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("The project is null");
        }
        if (ModelPackage.eINSTANCE.getProjectSpace().isInstance((Object)project.eContainer())) {
            return (ProjectSpace)project.eContainer();
        }
        throw new IllegalStateException("Project is not contained by any project space");
    }

    public static ObserverBus getObserverBus() {
        return ESWorkspaceProviderImpl.getInstance().observerBus;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public ESWorkspaceImpl getWorkspace() {
        return (ESWorkspaceImpl)this.getInternalWorkspace().toAPI();
    }

    public Workspace getInternalWorkspace() {
        if (this.currentWorkspace == null) {
            this.load();
        }
        return this.currentWorkspace;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager manager) {
        this.connectionManager = manager;
    }

    @Override
    public void setSessionProvider(ESAbstractSessionProvider sessionProvider) {
        this.getSessionManager().setSessionProvider(sessionProvider);
    }

    private void initialize() {
        this.observerBus = new ObserverBus();
        this.connectionManager = this.initConnectionManager();
        this.adminConnectionManager = this.initAdminConnectionManager();
        this.sessionManager = new SessionManager();
        this.load();
    }

    private void notifyPostWorkspaceInitiators() {
        for (ESExtensionElement element : new ESExtensionPoint("org.eclipse.emf.emfstore.client.notify.postinit", true).getExtensionElements()) {
            try {
                ((ESWorkspaceInitObserver)element.getClass("class", ESWorkspaceInitObserver.class)).workspaceInitComplete((ESWorkspace)this.currentWorkspace.toAPI());
            }
            catch (ESExtensionPointException e) {
                WorkspaceUtil.logException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private ConnectionManager initConnectionManager() {
        KeyStoreManager.getInstance().setupKeys();
        return new XmlRpcConnectionManager();
    }

    private AdminConnectionManager initAdminConnectionManager() {
        return new XmlRpcAdminConnectionManager();
    }

    private EditingDomain createEditingDomain(ResourceSet resourceSet) {
        ESEditingDomainProvider domainProvider = this.getDomainProvider();
        if (domainProvider != null) {
            return domainProvider.getEditingDomain(resourceSet);
        }
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{adapterFactory, new ReflectiveItemProviderAdapterFactory()});
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new EMFStoreBasicCommandStack(), resourceSet);
        resourceSet.eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)domain));
        return domain;
    }

    private ESEditingDomainProvider getDomainProvider() {
        return (ESEditingDomainProvider)new ESExtensionPoint("org.eclipse.emf.emfstore.client.editingDomainProvider").getClass("class", ESEditingDomainProvider.class);
    }

    private Workspace createNewWorkspace(ResourceSet resourceSet, URI fileURI) {
        final Resource resource = resourceSet.createResource(fileURI);
        final Workspace workspace = ModelFactory.eINSTANCE.createWorkspace();
        workspace.getServerInfos().addAll(Configuration.getClientBehavior().getDefaultServerInfos());
        EList<Usersession> usersessions = workspace.getUsersessions();
        for (ServerInfo serverInfo : workspace.getServerInfos()) {
            Usersession lastUsersession = serverInfo.getLastUsersession();
            if (lastUsersession == null) continue;
            usersessions.add((Object)lastUsersession);
        }
        new EMFStoreCommand(){

            protected void doRun() {
                resource.getContents().add((Object)workspace);
            }
        }.run(true);
        try {
            resource.save(ModelUtil.getResourceSaveOptions());
        }
        catch (IOException e) {
            WorkspaceUtil.logException("Creating new workspace failed! Delete workspace folder: " + Configuration.getFileInfo().getWorkspaceDirectory(), e);
        }
        try {
            int modelVersionNumber = ModelUtil.getModelVersionNumber();
            this.stampCurrentVersionNumber(modelVersionNumber);
        }
        catch (MalformedModelVersionException e1) {
            WorkspaceUtil.logException("Loading model version failed!", (Exception)((Object)e1));
        }
        return workspace;
    }

    private void stampCurrentVersionNumber(int modelReleaseNumber) {
        URI versionFileUri = URI.createFileURI((String)Configuration.getFileInfo().getModelReleaseNumberFileName());
        Resource versionResource = new ResourceSetImpl().createResource(versionFileUri);
        ModelVersion modelVersion = org.eclipse.emf.emfstore.internal.common.model.ModelFactory.eINSTANCE.createModelVersion();
        modelVersion.setReleaseNumber(modelReleaseNumber);
        versionResource.getContents().add((Object)modelVersion);
        try {
            ModelUtil.saveResource((Resource)versionResource, (IResourceLogger)WorkspaceUtil.getResourceLogger());
        }
        catch (IOException e) {
            WorkspaceUtil.logException("Version stamping workspace failed! Delete workspace folder: " + Configuration.getFileInfo().getWorkspaceDirectory(), e);
        }
    }

    private void migrateModel(ResourceSet resourceSet) {
        int modelVersionNumber;
        ModelVersion workspaceModelVersion = this.getWorkspaceModelVersion();
        try {
            modelVersionNumber = ModelUtil.getModelVersionNumber();
            this.stampCurrentVersionNumber(modelVersionNumber);
        }
        catch (MalformedModelVersionException e1) {
            WorkspaceUtil.logException("Loading model version failed, migration skipped!", (Exception)((Object)e1));
            return;
        }
        if (workspaceModelVersion.getReleaseNumber() == modelVersionNumber) {
            return;
        }
        if (workspaceModelVersion.getReleaseNumber() > modelVersionNumber) {
            this.backupAndRecreateWorkspace(resourceSet);
            WorkspaceUtil.logException("Model conforms to a newer version, update client! New workspace was backuped!", new IllegalStateException());
            return;
        }
        if (!EMFStoreMigratorUtil.isMigratorAvailable()) {
            WorkspaceUtil.logException("Model requires migration, but no migrators are registered!", new IllegalStateException());
            return;
        }
        this.backupWorkspace(false);
        File workspaceFile = new File(Configuration.getFileInfo().getWorkspaceDirectory());
        File[] fileArray = workspaceFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(Configuration.getFileInfo().getProjectSpaceDirectoryPrefix())) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(file.getAbsolutePath())).append(File.separatorChar);
                Configuration.getFileInfo();
                StringBuilder stringBuilder2 = stringBuilder.append("project");
                Configuration.getFileInfo();
                String projectFilePath = stringBuilder2.append(FileInfo.PROJECT_FILE_EXTENSION).toString();
                URI projectURI = URI.createFileURI((String)projectFilePath);
                String operationsFilePath = null;
                File[] listFiles = file.listFiles();
                if (listFiles == null) {
                    WorkspaceUtil.logException("The migration of the project in projectspace at " + projectFilePath + " failed!", new IllegalStateException("Broken projectSpace!"));
                } else {
                    File[] fileArray2 = listFiles;
                    int n3 = listFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File subDirFile = fileArray2[n4];
                        String string = subDirFile.getName();
                        Configuration.getFileInfo();
                        if (string.endsWith(".eoc")) {
                            operationsFilePath = subDirFile.getAbsolutePath();
                        }
                        ++n4;
                    }
                    if (operationsFilePath == null) {
                        WorkspaceUtil.logException("The migration of the project in projectspace at " + projectFilePath + " failed!", new IllegalStateException("Broken workspace!"));
                        this.backupAndRecreateWorkspace(resourceSet);
                    }
                    URI operationsURI = URI.createFileURI(operationsFilePath);
                    try {
                        this.migrate(projectURI, operationsURI, workspaceModelVersion.getReleaseNumber());
                    }
                    catch (EMFStoreMigrationException e) {
                        WorkspaceUtil.logException("The migration of the project in projectspace at " + projectFilePath + " failed!", (Exception)((Object)e));
                        this.backupAndRecreateWorkspace(resourceSet);
                    }
                }
            }
            ++n2;
        }
        this.stampCurrentVersionNumber(modelVersionNumber);
    }

    private void backupAndRecreateWorkspace(ResourceSet resourceSet) {
        this.backupWorkspace(true);
        URI fileURI = URI.createFileURI((String)Configuration.getFileInfo().getWorkspacePath());
        this.createNewWorkspace(resourceSet, fileURI);
    }

    private void backupWorkspace(boolean move) {
        String workspaceDirectory = Configuration.getFileInfo().getWorkspaceDirectory();
        File workspacePath = new File(workspaceDirectory);
        String newWorkspaceDirectory = String.valueOf(((DefaultServerWorkspaceLocationProvider)Configuration.getFileInfo().getLocationProvider()).getBackupDirectory()) + "emfstore_backup_" + System.currentTimeMillis();
        File workspacebackupPath = new File(newWorkspaceDirectory);
        if (move) {
            workspacePath.renameTo(workspacebackupPath);
        } else {
            try {
                FileUtil.copyDirectory((File)workspacePath, (File)workspacebackupPath);
            }
            catch (IOException e) {
                WorkspaceUtil.logException("Workspace backup failed!", e);
            }
        }
    }

    private ModelVersion getWorkspaceModelVersion() {
        File versionFile = new File(Configuration.getFileInfo().getModelReleaseNumberFileName());
        if (!versionFile.exists()) {
            try {
                int modelVersionNumber = ModelUtil.getModelVersionNumber();
                this.stampCurrentVersionNumber(modelVersionNumber);
            }
            catch (MalformedModelVersionException e1) {
                WorkspaceUtil.logException("Loading model version failed!", (Exception)((Object)e1));
            }
        }
        URI versionFileUri = URI.createFileURI((String)Configuration.getFileInfo().getModelReleaseNumberFileName());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource resource = resourceSet.getResource(versionFileUri, true);
            EList directContents = resource.getContents();
            ModelVersion modelVersion = (ModelVersion)directContents.get(0);
            return modelVersion;
        }
        catch (RuntimeException runtimeException) {
            ModelVersion modelVersion = org.eclipse.emf.emfstore.internal.common.model.ModelFactory.eINSTANCE.createModelVersion();
            modelVersion.setReleaseNumber(4);
            return modelVersion;
        }
    }

    private void migrate(URI projectURI, URI changesURI, int sourceModelReleaseNumber) throws EMFStoreMigrationException {
        ArrayList<URI> modelURIs = new ArrayList<URI>();
        modelURIs.add(projectURI);
        modelURIs.add(changesURI);
        EMFStoreMigratorUtil.getEMFStoreMigrator().migrate(modelURIs, sourceModelReleaseNumber, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void checkoutDone(ESLocalProject project) {
        this.flushCommandStack();
    }

    @Override
    public void shareDone(ESLocalProject localProject) {
        this.flushCommandStack();
    }

    @Override
    public boolean inspectChanges(ESLocalProject project, List<ESChangePackage> changePackages, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public void updateCompleted(ESLocalProject project, IProgressMonitor monitor) {
        this.flushCommandStack();
    }

    @Override
    public boolean inspectChanges(ESLocalProject project, ESChangePackage changePackage, IProgressMonitor monitor) {
        return true;
    }

    @Override
    public void commitCompleted(ESLocalProject project, ESPrimaryVersionSpec newRevision, IProgressMonitor monitor) {
        this.flushCommandStack();
    }
}

