/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.changes;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfstore.internal.client.ui.Activator;
import org.eclipse.emf.emfstore.internal.client.ui.common.OperationCustomLabelProvider;
import org.eclipse.emf.emfstore.internal.client.ui.views.changes.DefaultOperationLabelProvider;
import org.eclipse.emf.emfstore.internal.common.ExtensionRegistry;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceMoveOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.UnkownFeatureException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class ChangePackageVisualizationHelper {
    private ModelElementIdToEObjectMapping idToEObjectMapping;

    public ChangePackageVisualizationHelper(ModelElementIdToEObjectMapping idToEObjectMapping) {
        this.idToEObjectMapping = idToEObjectMapping;
    }

    public ImageDescriptor getOverlayImage(AbstractOperation operation) {
        CreateDeleteOperation op;
        String overlay = null;
        if (operation instanceof CreateDeleteOperation) {
            op = (CreateDeleteOperation)operation;
            overlay = op.isDelete() ? "icons/delete_overlay.png" : "icons/add_overlay.png";
        } else if (operation instanceof AttributeOperation) {
            op = (AttributeOperation)operation;
            overlay = op.getNewValue() == null ? "icons/delete_overlay.png" : (op.getOldValue() == null ? "icons/add_overlay.png" : "icons/modify_overlay.png");
        } else if (operation instanceof SingleReferenceOperation) {
            op = (SingleReferenceOperation)operation;
            overlay = op.getNewValue() == null ? "icons/delete_overlay.png" : "icons/link_overlay.png";
        } else if (operation instanceof MultiReferenceOperation) {
            op = (MultiReferenceOperation)operation;
            if (op.getReferencedModelElements().size() > 0) {
                overlay = "icons/link_overlay.png";
            }
        } else {
            overlay = operation instanceof MultiReferenceMoveOperation ? "icons/link_overlay.png" : "icons/modify_overlay.png";
        }
        ImageDescriptor overlayDescriptor = Activator.getImageDescriptor(overlay);
        return overlayDescriptor;
    }

    public Image getImage(ILabelProvider emfProvider, AbstractOperation operation) {
        Image image = this.getCustomOperationProviderLabel(operation);
        if (image != null) {
            return image;
        }
        return emfProvider.getImage((Object)operation);
    }

    private Image getCustomOperationProviderLabel(AbstractOperation operation) {
        OperationCustomLabelProvider customLabelProvider = (OperationCustomLabelProvider)ExtensionRegistry.INSTANCE.get("org.eclipse.emf.emfstore.internal.client.ui.common.operationCustomLabelProvider", OperationCustomLabelProvider.class, (Object)new DefaultOperationLabelProvider(), true);
        if (customLabelProvider != null) {
            try {
                return (Image)customLabelProvider.getImage(operation);
            }
            catch (RuntimeException e) {
                ModelUtil.logWarning((String)"Image load from custom operation item provider failed!", (Throwable)e);
            }
        }
        return null;
    }

    public String getDescription(AbstractOperation op) {
        CompositeOperation compositeOperation;
        OperationCustomLabelProvider customLabelProvider = (OperationCustomLabelProvider)ExtensionRegistry.INSTANCE.get("org.eclipse.emf.emfstore.internal.client.ui.common.operationCustomLabelProvider", OperationCustomLabelProvider.class, (Object)new DefaultOperationLabelProvider(), true);
        if (op instanceof CompositeOperation && (compositeOperation = (CompositeOperation)op).getMainOperation() != null) {
            return this.getDescription(compositeOperation.getMainOperation());
        }
        return this.decorate(customLabelProvider, op);
    }

    private String decorate(OperationCustomLabelProvider labelProvider, AbstractOperation op) {
        String namesResolved = this.resolveIds(labelProvider, labelProvider.getDescription(op), "%%%", op);
        String allResolved = this.resolveIds(labelProvider, namesResolved, "&&&", op);
        if (op instanceof ReferenceOperation) {
            return this.resolveTypes(allResolved, (ReferenceOperation)op);
        }
        if (op instanceof CompositeOperation && ((CompositeOperation)op).getMainOperation() != null && ((CompositeOperation)op).getMainOperation() instanceof ReferenceOperation) {
            return this.resolveTypes(allResolved, (ReferenceOperation)((CompositeOperation)op).getMainOperation());
        }
        return allResolved;
    }

    private String resolveTypes(String unresolvedString, ReferenceOperation op) {
        String type;
        EObject modelElement = this.getModelElement(op.getModelElementId());
        if (modelElement == null) {
            type = "ModelElement";
        } else {
            try {
                EStructuralFeature feature = op.getFeature(modelElement);
                type = feature.getEType().getName();
            }
            catch (UnkownFeatureException unkownFeatureException) {
                type = "ModelElement";
            }
        }
        return unresolvedString.replace("#REFERENCE_TYPE_NAME#", type);
    }

    private String resolveIds(OperationCustomLabelProvider labelProvider, String unresolvedString, String devider, AbstractOperation op) {
        String[] strings = unresolvedString.split(devider);
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            if (this.isOdd(i)) {
                ModelElementId modelElementId = ModelFactory.eINSTANCE.createModelElementId();
                modelElementId.setId(strings[i]);
                EObject modelElement = this.getModelElement(modelElementId);
                if (modelElement != null) {
                    stringBuilder.append(labelProvider.getModelElementName(modelElement));
                } else if (modelElement == null && op instanceof CreateDeleteOperation) {
                    CreateDeleteOperation createDeleteOp = (CreateDeleteOperation)op;
                    for (Map.Entry entry : createDeleteOp.getEObjectToIdMap()) {
                        if (!((ModelElementId)entry.getValue()).equals(modelElementId)) continue;
                        stringBuilder.append(labelProvider.getModelElementName((EObject)entry.getKey()));
                        break;
                    }
                }
            } else {
                stringBuilder.append(strings[i]);
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    private boolean isOdd(int i) {
        int res = i % 2;
        return res == -1 || res == 1;
    }

    public EObject getModelElement(ModelElementId modelElementId) {
        return this.idToEObjectMapping.get((Object)modelElementId);
    }
}

