/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.emfstore.internal.common.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommonUtil {
    private static boolean testing;
    private static Set<EClass> registryEClasses;

    private CommonUtil() {
    }

    public static EReference getPossibleContainingReference(EObject containee, EObject parent) {
        EList eAllContainments = parent.eClass().getEAllContainments();
        EReference reference = null;
        for (EReference containmentItem : eAllContainments) {
            EClass eReferenceType = containmentItem.getEReferenceType();
            if (eReferenceType.equals(containee)) {
                reference = containmentItem;
                break;
            }
            if (!eReferenceType.equals(EcorePackage.eINSTANCE.getEObject()) && !eReferenceType.isSuperTypeOf(containee.eClass())) continue;
            reference = containmentItem;
            break;
        }
        return reference;
    }

    public static Set<EClass> getAllEContainments(EClass eClass) {
        EList containments = eClass.getEAllContainments();
        LinkedHashSet<EClass> eClasses = new LinkedHashSet<EClass>();
        for (EReference ref : containments) {
            EClass eReferenceType = ref.getEReferenceType();
            eClasses.addAll(CommonUtil.getAllSubEClasses(eReferenceType));
        }
        return eClasses;
    }

    public static Set<EClass> getAllSubEClasses(EClass eClass) {
        Set<EClass> allEClasses = CommonUtil.getAllModelElementEClasses();
        if (EcorePackage.eINSTANCE.getEObject().equals(eClass)) {
            return allEClasses;
        }
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        for (EClass subClass : allEClasses) {
            boolean isSuperTypeOf;
            boolean bl = isSuperTypeOf = eClass.isSuperTypeOf(subClass) || eClass.equals(EcorePackage.eINSTANCE.getEObject());
            if (!isSuperTypeOf || subClass.isAbstract() || subClass.isInterface()) continue;
            result.add(subClass);
        }
        return result;
    }

    public static Set<EClass> getAllModelElementEClasses() {
        if (registryEClasses != null) {
            return new LinkedHashSet<EClass>(registryEClasses);
        }
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        for (Map.Entry entry : new LinkedHashSet(registry.entrySet())) {
            try {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage((String)entry.getKey());
                result.addAll(CommonUtil.getAllModelElementEClasses(ePackage));
            }
            catch (RuntimeException exception) {
                Activator.getDefault().logException("Failed to load model package " + (String)entry.getKey(), exception);
            }
        }
        registryEClasses = result;
        return result;
    }

    private static Set<EClass> getAllModelElementEClasses(EPackage ePackage) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        for (EPackage subPackage : ePackage.getESubpackages()) {
            result.addAll(CommonUtil.getAllModelElementEClasses(subPackage));
        }
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            EClass subEClass = (EClass)classifier;
            result.add(subEClass);
        }
        return result;
    }

    public static <T extends EObject> T getParent(Class<T> parent, EObject child) {
        LinkedHashSet<EObject> seenModelElements = new LinkedHashSet<EObject>();
        seenModelElements.add(child);
        return CommonUtil.getParent(parent, child, seenModelElements);
    }

    private static <T extends EObject> T getParent(Class<T> parent, EObject child, Set<EObject> seenModelElements) {
        if (child == null) {
            return null;
        }
        if (seenModelElements.contains(child.eContainer())) {
            throw new IllegalStateException("ModelElement is in a containment cycle");
        }
        if (parent.isInstance(child)) {
            return (T)child;
        }
        seenModelElements.add(child);
        return CommonUtil.getParent(parent, child.eContainer(), seenModelElements);
    }

    public static boolean isSelfContained(EObject object) {
        return CommonUtil.isSelfContained(object, false);
    }

    public static boolean isSelfContained(EObject eObject, boolean ignoreContainer) {
        Set<EObject> allChildEObjects = CommonUtil.getNonTransientContents(eObject);
        LinkedHashSet<EObject> allEObjects = new LinkedHashSet<EObject>(allChildEObjects);
        allEObjects.add(eObject);
        Set<EObject> nonTransientReferences = CommonUtil.getNonTransientCrossReferences(eObject);
        if (ignoreContainer && eObject.eContainer() != null) {
            nonTransientReferences.remove(eObject.eContainer());
        }
        return allEObjects.containsAll(nonTransientReferences);
    }

    public static Set<EObject> getNonTransientContents(EObject eObject) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        if (eObject == null) {
            return result;
        }
        for (EReference containmentReference : eObject.eClass().getEAllContainments()) {
            if (containmentReference.isTransient()) continue;
            Object contentObject = eObject.eGet((EStructuralFeature)containmentReference, true);
            if (containmentReference.isMany()) {
                EList contentList = (EList)contentObject;
                for (EObject content : contentList) {
                    result.add(content);
                    result.addAll(CommonUtil.getNonTransientContents(content));
                }
                continue;
            }
            EObject content = (EObject)contentObject;
            if (content == null) continue;
            result.add(content);
            result.addAll(CommonUtil.getNonTransientContents(content));
        }
        return result;
    }

    private static Set<EObject> getNonTransientCrossReferences(EObject object) {
        LinkedHashSet<EObject> result = new LinkedHashSet<EObject>();
        if (object == null) {
            return result;
        }
        for (EReference reference : object.eClass().getEAllReferences()) {
            if (reference.isTransient() || reference.isContainment()) continue;
            Object referenceObject = object.eGet((EStructuralFeature)reference, true);
            if (reference.isMany()) {
                EList referencesList = (EList)referenceObject;
                result.addAll((Collection<EObject>)referencesList);
                for (EObject ref : referencesList) {
                    if (CommonUtil.isSingletonEObject(ref)) continue;
                    result.add(ref);
                }
                continue;
            }
            EObject crossReference = (EObject)referenceObject;
            if (crossReference == null || CommonUtil.isSingletonEObject(crossReference)) continue;
            result.add(crossReference);
        }
        return result;
    }

    public static boolean isSingletonEObject(EObject eObject) {
        return eObject.eContainer() != null && eObject.eContainer().equals(EcorePackage.eINSTANCE);
    }

    private static Set<EObject> validation(Resource resource, List<String> errorStrings) {
        EObject content;
        LinkedHashSet childrenSet = new LinkedHashSet();
        LinkedHashSet<EObject> rootNodes = new LinkedHashSet<EObject>();
        TreeIterator contents = resource.getAllContents();
        while (contents.hasNext()) {
            content = (EObject)contents.next();
            childrenSet.addAll(content.eContents());
        }
        contents = resource.getAllContents();
        while (contents.hasNext()) {
            content = (EObject)contents.next();
            if (childrenSet.contains(content)) continue;
            rootNodes.add(content);
        }
        LinkedHashSet<EObject> notSelfContained = new LinkedHashSet<EObject>();
        for (EObject rootNode : rootNodes) {
            if (CommonUtil.isSelfContained(rootNode)) continue;
            errorStrings.add(rootNode + " is not self contained\n");
            notSelfContained.add(rootNode);
        }
        rootNodes.removeAll(notSelfContained);
        return rootNodes;
    }

    public static Set<EObject> loadFromResource(Resource resource, List<String> errorStrings) {
        return CommonUtil.validation(resource, errorStrings);
    }

    public static void setTesting(boolean testing) {
        CommonUtil.testing = testing;
    }

    public static boolean isTesting() {
        return testing;
    }

    public static String getEncoding() {
        return "UTF-8";
    }
}

