/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.modelmutator.intern;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutatorConfiguration;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelMutator {
    private ModelMutatorConfiguration config;
    private Map<EReference, List<EClass>> referencesToClasses = new LinkedHashMap<EReference, List<EClass>>();
    private Map<EClass, List<EObject>> freeObjects = new LinkedHashMap<EClass, List<EObject>>();
    private Map<EClass, List<EObject>> allObjects = new LinkedHashMap<EClass, List<EObject>>();
    private ModelMutatorUtil util;
    private int currentObjectCount;
    private int targetObjectCount;
    private int currentWidth = 1;
    private int currentDepth = 1;

    public AbstractModelMutator(ModelMutatorConfiguration config) {
        this.config = config;
        this.util = new ModelMutatorUtil(config);
        this.targetObjectCount = config.getMinObjectsCount();
    }

    public abstract void preMutate();

    public abstract void postMutate();

    public void generate() {
        this.preMutate();
        Random random = this.config.getRandom();
        while (this.currentObjectCount < this.targetObjectCount) {
            this.createChildrenForRoot();
            ++this.currentWidth;
            if (!random.nextBoolean() || !random.nextBoolean() || !random.nextBoolean()) continue;
            ++this.currentDepth;
        }
        this.postMutate();
    }

    public void mutate() {
        this.deleteEObjects(this.config.getRootEObject());
        this.currentObjectCount = ModelMutatorUtil.getAllObjectsCount(this.config.getRootEObject());
        this.generate();
        this.changeCrossReferences();
        this.mutateAttributes();
    }

    public void createChildrenForRoot() {
        if (this.config.isDoNotGenerateRoot()) {
            for (EObject obj : this.config.getRootEObject().eContents()) {
                this.createChildren(obj, 1);
            }
        } else {
            this.createChildren(this.config.getRootEObject(), 0);
        }
    }

    public void createChildren(EObject root, int depth) {
        if (this.currentObjectCount >= this.targetObjectCount) {
            return;
        }
        if (depth >= this.currentDepth) {
            return;
        }
        List<EObject> children = this.createChildren(root);
        for (EObject obj : children) {
            this.createChildren(obj, depth + 1);
        }
    }

    public List<EObject> createChildren(EObject root) {
        ArrayList<EObject> children = new ArrayList<EObject>();
        Collection<EStructuralFeature> ignore = this.config.geteStructuralFeaturesToIgnore();
        Random random = this.config.getRandom();
        for (EReference reference : root.eClass().getEAllContainments()) {
            if (ignore.contains(reference) || !this.util.isValid((EStructuralFeature)reference, root)) continue;
            int i = this.currentWidth / 2 - root.eContents().size();
            while (i > 0) {
                EClass eClass = this.getValidEClass(reference);
                if (eClass != null) {
                    EObject obj = this.getEObject(eClass);
                    if (random.nextBoolean()) {
                        this.changeCrossReferences(obj);
                    }
                    if (reference.isMany() || i == 1) {
                        this.addToParent(root, obj, reference);
                        children.add(obj);
                        ++this.currentObjectCount;
                        this.currentObjectCount += obj.eContents().size();
                    } else {
                        this.addToEClassToObjectsMap(obj, this.freeObjects);
                    }
                    this.addToEClassToObjectsMap(obj, this.allObjects);
                    if (this.currentObjectCount >= this.targetObjectCount) {
                        return children;
                    }
                }
                --i;
            }
        }
        return children;
    }

    public void deleteEObjects(EObject root) {
        ArrayList<EObject> toDelete = new ArrayList<EObject>();
        Random random = this.config.getRandom();
        int maxDeleteCount = this.config.getMaxDeleteCount();
        int deleted = 0;
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (deleted < maxDeleteCount && random.nextBoolean()) {
                toDelete.add(obj);
                ++deleted;
                this.addToEClassToObjectsMap(obj, this.freeObjects);
            }
            this.addToEClassToObjectsMap(obj, this.allObjects);
        }
        ArrayList<Integer> deleteModes = new ArrayList<Integer>();
        deleteModes.add(0);
        deleteModes.add(1);
        if (this.config.isUseEcoreUtilDelete()) {
            deleteModes.add(2);
        }
        int size = deleteModes.size();
        for (EObject obj : new ArrayList(toDelete)) {
            this.util.removeFullPerCommand(obj, (Integer)deleteModes.get(random.nextInt(size)));
        }
    }

    private void addToEClassToObjectsMap(EObject obj, Map<EClass, List<EObject>> map) {
        List<EObject> objects = map.get(obj.eClass());
        if (objects == null) {
            objects = new ArrayList<EObject>();
            map.put(obj.eClass(), objects);
        }
        objects.add(obj);
    }

    protected EClass getValidEClass(EReference reference) {
        List<EClass> classes = this.referencesToClasses.get(reference);
        if (classes == null) {
            classes = this.util.getAllEContainments(reference);
            for (EClass eClass : this.config.geteClassesToIgnore()) {
                classes.remove(eClass);
                classes.removeAll(this.util.getAllSubEClasses(eClass));
            }
            for (EClass eClass : new ArrayList<EClass>(classes)) {
                if (ModelMutatorUtil.canHaveInstance(eClass)) continue;
                classes.remove(eClass);
            }
            if (classes.isEmpty()) {
                return null;
            }
            this.referencesToClasses.put(reference, classes);
        }
        int index = this.config.getRandom().nextInt(classes.size());
        return classes.get(index);
    }

    protected EObject getEObject(EClass eClass) {
        Random random = this.config.getRandom();
        EObject newObject = null;
        List<EObject> objects = this.freeObjects.get(eClass);
        newObject = objects != null && objects.size() != 0 && random.nextBoolean() ? objects.remove(random.nextInt(objects.size())) : EcoreUtil.create((EClass)eClass);
        this.util.setEObjectAttributes(newObject);
        return newObject;
    }

    private void addToParent(EObject parent, EObject newObject, EReference reference) {
        Random random = this.config.getRandom();
        if (reference.isMany()) {
            this.util.addPerCommand(parent, (EStructuralFeature)reference, newObject, random.nextBoolean() ? Integer.valueOf(0) : null);
        } else {
            this.util.setPerCommand(parent, (EStructuralFeature)reference, newObject);
        }
    }

    public void mutateAttributes() {
        TreeIterator it = this.config.getRootEObject().eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            this.util.setEObjectAttributes(obj);
        }
    }

    public void changeCrossReferences() {
        for (Map.Entry<EClass, List<EObject>> entry : this.allObjects.entrySet()) {
            for (EObject obj : entry.getValue()) {
                this.changeCrossReferences(obj);
            }
        }
    }

    public void changeCrossReferences(EObject obj) {
        for (EReference reference : this.util.getValidCrossReferences(obj)) {
            for (EClass referenceClass : this.util.getReferenceClasses(reference, this.allObjects.keySet())) {
                this.util.setReference(obj, referenceClass, reference, this.allObjects);
            }
        }
    }
}

