/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.controller;

import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.observer.ESLoginObserver;
import org.eclipse.emf.emfstore.client.observer.ESShareObserver;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.common.UnknownEMFStoreWorkloadCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.model.impl.AdminBrokerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesPackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareController
extends ServerCall<ProjectInfo> {
    public ShareController(ProjectSpaceBase projectSpace, Usersession session, IProgressMonitor monitor) {
        super(projectSpace);
        this.setUsersession(session);
        this.setProgressMonitor(monitor);
    }

    @Override
    protected ProjectInfo run() throws ESException {
        this.getProgressMonitor().beginTask(Messages.ShareController_Sharing_Project, 100);
        this.getProgressMonitor().worked(1);
        this.getProgressMonitor().subTask(Messages.ShareController_Preparing_Share);
        LogMessage logMessage = VersioningFactory.eINSTANCE.createLogMessage();
        logMessage.setAuthor(this.getUsersession().getUsername());
        logMessage.setClientDate(new Date());
        logMessage.setMessage(Messages.ShareController_Initial_Commit);
        ProjectInfo projectInfo = null;
        this.getProjectSpace().stopChangeRecording();
        this.getProgressMonitor().worked(10);
        if (this.getProgressMonitor().isCanceled()) {
            this.getProjectSpace().save();
            this.getProjectSpace().startChangeRecording();
            this.getProgressMonitor().done();
        }
        this.getProgressMonitor().subTask(Messages.ShareController_Sharing_Project_With_Server);
        this.getProjectSpace().save();
        projectInfo = this.createProject(logMessage);
        this.addParticipant(projectInfo.getProjectId());
        this.getProgressMonitor().worked(30);
        this.getProgressMonitor().subTask("Finalizing share");
        this.getProgressMonitor().subTask(Messages.ShareController_Settings_Attributes);
        this.setUsersession(this.getUsersession());
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this.getProjectSpace(), new Class[]{ESLoginObserver.class});
        this.getProjectSpace().save();
        this.getProjectSpace().startChangeRecording();
        this.getProjectSpace().setBaseVersion((PrimaryVersionSpec)ModelUtil.clone((EObject)projectInfo.getVersion()));
        this.getProjectSpace().setLastUpdated(new Date());
        this.getProjectSpace().setProjectId((ProjectId)ModelUtil.clone((EObject)projectInfo.getProjectId()));
        this.getProjectSpace().setUsersession(this.getUsersession());
        this.getProjectSpace().saveProjectSpaceOnly();
        this.getProgressMonitor().worked(20);
        this.getProgressMonitor().subTask(Messages.ShareController_Uploading_Files);
        this.getProjectSpace().getFileTransferManager().uploadQueuedFiles(this.getProgressMonitor());
        this.getProgressMonitor().worked(20);
        this.getProgressMonitor().subTask(Messages.ShareController_Finalizing_Share);
        this.getProjectSpace().getOperations().clear();
        this.getProjectSpace().updateDirtyState();
        this.getProgressMonitor().done();
        ((ESShareObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESShareObserver.class)).shareDone(this.getProjectSpace().toAPI());
        return projectInfo;
    }

    private ProjectInfo createProject(final LogMessage logMessage) throws ESException {
        return (ProjectInfo)new UnknownEMFStoreWorkloadCommand<ProjectInfo>(this.getProgressMonitor()){

            @Override
            public ProjectInfo run(IProgressMonitor monitor) throws ESException {
                return ESWorkspaceProviderImpl.getInstance().getConnectionManager().createProject(ShareController.this.getUsersession().getSessionId(), ShareController.this.getProjectSpace().getProjectName() == null ? MessageFormat.format(Messages.ShareController_Project_At, new Date()) : ShareController.this.getProjectSpace().getProjectName(), "", logMessage, ShareController.this.getProjectSpace().getProject());
            }
        }.execute();
    }

    private void addParticipant(final ProjectId projectId) throws ESException {
        new UnknownEMFStoreWorkloadCommand<Void>(this.getProgressMonitor()){

            @Override
            public Void run(IProgressMonitor monitor) throws ESException {
                new AdminBrokerImpl(ShareController.this.getUsersession().getServerInfo(), ShareController.this.getSessionId()).addInitialParticipant(projectId, ShareController.this.getUsersession().getACUser().getId(), RolesPackage.eINSTANCE.getProjectAdminRole());
                return null;
            }
        }.execute();
    }
}

