/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class EMFStorePreferenceHelper {
    private static final String PREFERENCE_NODE = "emfstore";

    private EMFStorePreferenceHelper() {
    }

    public static String getPreference(String key, String defaultValue) {
        return Platform.getPreferencesService().getRootNode().node("configuration").node(PREFERENCE_NODE).get(key, defaultValue);
    }

    public static void setPreference(String key, String value) {
        if (key != null && value != null) {
            Preferences node = Platform.getPreferencesService().getRootNode().node("configuration").node(PREFERENCE_NODE);
            node.put(key, value);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                WorkspaceUtil.handleException((String)("Could not persist the preference change: {" + key + ", " + value + "}"), (Exception)((Object)e));
            }
        }
    }
}

