/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.extensionregistry;

import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.util.ChecksumErrorHandler;
import org.eclipse.emf.emfstore.internal.common.ExtensionRegistry;
import org.eclipse.emf.emfstore.server.ESLocationProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ExtensionRegistryTest {
    @After
    public void teardown() {
        ExtensionRegistry.INSTANCE.remove("foo.bar");
    }

    @Test
    public void testGetDefaultErrorChecksumHandler() {
        Assert.assertEquals((Object)ChecksumErrorHandler.CANCEL, (Object)Configuration.getClientBehavior().getChecksumErrorHandler());
    }

    @Test
    public void testGetType() {
        Bar bar = (Bar)ExtensionRegistry.INSTANCE.get("foo.bar", Bar.class);
        Assert.assertEquals(null, (Object)bar);
    }

    @Test
    public void testGetTypeWithDefault() {
        Bar bar = new Bar();
        Bar defaultBar = (Bar)ExtensionRegistry.INSTANCE.get("foo.bar", Bar.class, (Object)bar, false);
        Assert.assertEquals((Object)bar, (Object)defaultBar);
    }

    @Test
    public void testRegisterType() {
        Bar bar = new Bar();
        ExtensionRegistry.INSTANCE.set("foo.bar", (Object)bar);
        Assert.assertEquals((Object)bar, (Object)ExtensionRegistry.INSTANCE.get("foo.bar", Bar.class));
    }

    @Test
    public void testGetTypeWithDefaultAndSetItAsDefault() {
        Bar bar = new Bar();
        Bar defaultBar = (Bar)ExtensionRegistry.INSTANCE.get("foo.bar", Bar.class, (Object)bar, true);
        Assert.assertEquals((Object)bar, (Object)defaultBar);
        Assert.assertEquals((Object)bar, (Object)ExtensionRegistry.INSTANCE.get("foo.bar", Bar.class));
    }

    @Test
    public void testGetExtensionElement() {
        ESLocationProvider locationProvider = (ESLocationProvider)ExtensionRegistry.INSTANCE.get("org.eclipse.emf.emfstore.server.locationProvider.providerClass", ESLocationProvider.class);
        Assert.assertNotNull((Object)locationProvider);
    }

    class Bar {
        Bar() {
        }
    }
}

