/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.conflictDetection;

import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.impl.ESModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.Messages;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CreateDeleteOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.OperationUtil;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementIdToEObjectMappingImpl
implements ModelElementIdToEObjectMapping {
    private final Map<String, EObject> idToEObjectMapping;
    private final ModelElementIdToEObjectMapping delegateMapping;
    private ESModelElementIdToEObjectMappingImpl apiImpl;

    public ModelElementIdToEObjectMappingImpl(ModelElementIdToEObjectMapping mapping) {
        this.delegateMapping = mapping;
        this.idToEObjectMapping = new LinkedHashMap<String, EObject>();
    }

    public ModelElementIdToEObjectMappingImpl(ModelElementIdToEObjectMapping mapping, List<AbstractChangePackage> changePackages) {
        this(mapping);
        for (AbstractChangePackage changePackage : changePackages) {
            this.put(changePackage);
        }
    }

    public ModelElementIdToEObjectMappingImpl(ModelElementIdToEObjectMapping mapping, List<AbstractOperation> operationsList1, List<AbstractOperation> operationsList2) {
        this(mapping);
        this.put((Iterable<AbstractOperation>)operationsList1);
        this.put((Iterable<AbstractOperation>)operationsList2);
    }

    public ModelElementIdToEObjectMappingImpl(Project project, AbstractChangePackage changePackage) {
        this((ModelElementIdToEObjectMapping)project);
        this.put(changePackage);
    }

    public void put(List<AbstractChangePackage> changePackages) {
        for (AbstractChangePackage changePackage : changePackages) {
            this.put(changePackage);
        }
    }

    public void put(AbstractChangePackage changePackage) {
        ESCloseableIterable operations = changePackage.operations();
        try {
            for (AbstractOperation operation : operations.iterable()) {
                this.scanOperationIntoMapping(operation);
            }
        }
        finally {
            operations.close();
        }
    }

    public void put(Iterable<AbstractOperation> operations) {
        for (AbstractOperation op : operations) {
            this.scanOperationIntoMapping(op);
        }
    }

    private void scanOperationIntoMapping(AbstractOperation operation) {
        if (operation instanceof CompositeOperation) {
            CompositeOperation composite = (CompositeOperation)operation;
            for (AbstractOperation subOp : composite.getSubOperations()) {
                this.scanOperationIntoMapping(subOp);
            }
            return;
        }
        if (OperationUtil.isCreateDelete((AbstractOperation)operation)) {
            CreateDeleteOperation createDeleteOperation = (CreateDeleteOperation)operation;
            if (createDeleteOperation.getEObjectToIdMap().keySet().contains(null)) {
                ModelUtil.logWarning((String)MessageFormat.format(Messages.ModelElementIdToEObjectMappingImpl_CreateDeleteOp_NullKey, createDeleteOperation.getIdentifier()));
            }
            for (Map.Entry entry : createDeleteOperation.getEObjectToIdMap().entrySet()) {
                ModelElementId modelElementId = (ModelElementId)entry.getValue();
                EObject modelElement = (EObject)entry.getKey();
                if (this.delegateMapping.get((Object)modelElementId) != null) continue;
                this.idToEObjectMapping.put(modelElementId.getId(), modelElement);
            }
        }
    }

    public EObject get(ModelElementId modelElementId) {
        EObject eObject = this.delegateMapping.get((Object)modelElementId);
        if (eObject != null) {
            return eObject;
        }
        if (modelElementId == null) {
            return null;
        }
        return this.idToEObjectMapping.get(modelElementId.getId());
    }

    public ESModelElementIdToEObjectMappingImpl toAPI() {
        if (this.apiImpl == null) {
            this.apiImpl = this.createAPI();
        }
        return this.apiImpl;
    }

    public ESModelElementIdToEObjectMappingImpl createAPI() {
        return new ESModelElementIdToEObjectMappingImpl((ModelElementIdToEObjectMapping)this);
    }
}

