/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.emfstore.fuzzy.emf.internal.junit.FrameworkFields;
import org.eclipse.emf.emfstore.fuzzy.emf.internal.junit.FuzzyTestClassRunner;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.Annotations;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESFuzzyDataProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.ESFuzzyUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.junit.Messages;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.InitializationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESFuzzyRunner
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();
    private final ESFuzzyDataProvider<?> dataProvider = this.getDataProvider();
    public static final String NAME_SEPARATOR = " ";

    public ESFuzzyRunner(Class<?> clazz) throws InitializationError {
        super(clazz, Collections.emptyList());
        this.dataProvider.setTestClass(this.getTestClass());
        this.dataProvider.init();
        ESFuzzyUtil util = this.dataProvider.getUtil();
        FrameworkFields fields = FrameworkFields.create().setDataField(this.getDataField()).setUtilField(this.getUtilField()).setMutatorField(this.getMutatorField()).setOptionsField(this.getOptionsField());
        int i = 0;
        while (i < this.dataProvider.size()) {
            FuzzyTestClassRunner runner = new FuzzyTestClassRunner(clazz, this.dataProvider, fields, util, i + 1);
            if (runner.getChildren().size() > 0) {
                this.runners.add((Runner)runner);
            }
            ++i;
        }
    }

    public void run(RunNotifier notifier) {
        List<RunListener> listener = this.dataProvider.getListener();
        if (listener != null) {
            for (RunListener runListener : listener) {
                notifier.addListener(runListener);
            }
        }
        super.run(notifier);
    }

    private FrameworkField getUtilField() {
        return this.getSingleStaticFrameworkField(Annotations.Util.class);
    }

    private FrameworkField getMutatorField() {
        return this.getSingleStaticFrameworkField(Annotations.Mutator.class);
    }

    private FrameworkField getOptionsField() {
        return this.getSingleStaticFrameworkField(Annotations.Options.class);
    }

    private FrameworkField getSingleStaticFrameworkField(Class<? extends Annotation> annotation) {
        List fields = this.getTestClass().getAnnotatedFields(annotation);
        if (fields.size() > 1) {
            throw new RuntimeException(MessageFormat.format(Messages.getString("ESFuzzyRunner.OneAnnotationOnly"), annotation.getSimpleName(), this.getTestClass().getName(), fields.size()));
        }
        for (FrameworkField field : fields) {
            int modifiers = field.getField().getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            return field;
        }
        return null;
    }

    private FrameworkField getDataField() throws InitializationError {
        FrameworkField field = this.getSingleStaticFrameworkField(Annotations.Data.class);
        if (field == null) {
            throw new InitializationError(MessageFormat.format(Messages.getString("ESFuzzyRunner.NonStaticFieldMissing"), Annotations.Data.class.getSimpleName(), this.getTestClass().getName()));
        }
        return field;
    }

    private ESFuzzyDataProvider<?> getDataProvider() throws InitializationError {
        Annotation[] annotations = this.getTestClass().getAnnotations();
        Class<?> dataProviderClass = null;
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation instanceof Annotations.DataProvider && !ESFuzzyDataProvider.class.isAssignableFrom(dataProviderClass = ((Annotations.DataProvider)annotation).value())) {
                throw new InitializationError(MessageFormat.format(Messages.getString("ESFuzzyRunner.NotAnInstanceOf"), dataProviderClass, ESFuzzyDataProvider.class.getSimpleName()));
            }
            ++n2;
        }
        try {
            return (ESFuzzyDataProvider)dataProviderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException instantiationException) {
            throw new InitializationError(Messages.getString("ESFuzzyRunner.DataProviderCTorMissing"));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InitializationError(Messages.getString("ESFuzzyRunner.DataProviderCTorMissing"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InitializationError(Messages.getString("ESFuzzyRunner.DataProviderCTorMissing"));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InitializationError(Messages.getString("ESFuzzyRunner.DataProviderCTorMissing"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InitializationError(Messages.getString("ESFuzzyRunner.DataProviderCTorMissing"));
        }
        catch (SecurityException securityException) {
            throw new InitializationError(Messages.getString("ESFuzzyRunner.DataProviderCTorMissing"));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }
}

