/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.Messages;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.ChangePackageUtil;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePackageFragmentProviderAdapter
extends AdapterImpl {
    private final Map<String, Map<Integer, List<AbstractOperation>>> proxyIdToChangePackageFragments = new LinkedHashMap<String, Map<Integer, List<AbstractOperation>>>();

    public void addAsFragments(String proxyId, AbstractChangePackage changePackage) {
        Iterator envelopes = ChangePackageUtil.splitChangePackage((AbstractChangePackage)changePackage, (int)((Integer)ServerConfiguration.getChangePackageFragmentSize().get()));
        while (envelopes.hasNext()) {
            this.addFragment(proxyId, (List<AbstractOperation>)((ChangePackageEnvelope)envelopes.next()).getFragment());
        }
    }

    private void addFragment(String proxyId, List<AbstractOperation> fragment) {
        Map<Integer, List<AbstractOperation>> map = this.proxyIdToChangePackageFragments.get(proxyId);
        if (map == null) {
            map = new LinkedHashMap<Integer, List<AbstractOperation>>();
            this.proxyIdToChangePackageFragments.put(proxyId, map);
        }
        int currentSize = map.size();
        map.put(currentSize, fragment);
    }

    public List<AbstractOperation> getFragment(String proxyId, int fragmentIndex) throws ESException {
        Map<Integer, List<AbstractOperation>> fragments = this.proxyIdToChangePackageFragments.get(proxyId);
        if (fragments == null) {
            throw new ESException(Messages.ChangePackageFragmentProviderAdapter_NoFragmentsFound);
        }
        return fragments.get(fragmentIndex);
    }

    public int getFragmentSize(String proxyId) {
        Map<Integer, List<AbstractOperation>> map = this.proxyIdToChangePackageFragments.get(proxyId);
        if (map == null) {
            return -1;
        }
        return map.size();
    }

    public void markAsConsumed(String proxyId) {
        this.proxyIdToChangePackageFragments.remove(proxyId);
    }
}

