/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.h2.Driver;
import org.h2.constant.SysProperties;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXid;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.util.ByteUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;

public class JdbcXAConnection
extends TraceObject
implements XAConnection,
XAResource {
    private static int nextTransactionId;
    private JdbcDataSourceFactory factory;
    private String url;
    private String user;
    private JdbcConnection physicalConn;
    private PooledJdbcConnection handleConn;
    private ArrayList<ConnectionEventListener> listeners = New.arrayList();
    private Xid currentTransaction;
    private int currentTransactionId;

    JdbcXAConnection(JdbcDataSourceFactory jdbcDataSourceFactory, int n, String string, String string2, char[] cArray) throws SQLException {
        this.factory = jdbcDataSourceFactory;
        this.setTrace(jdbcDataSourceFactory.getTrace(), 13, n);
        this.url = string;
        this.user = string2;
        Properties properties = new Properties();
        properties.setProperty("user", string2);
        properties.put("password", StringUtils.cloneCharArray(cArray));
        this.physicalConn = new JdbcConnection(string, properties);
    }

    public XAResource getXAResource() {
        this.debugCodeCall("getXAResource");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        this.debugCodeCall("close");
        if (this.handleConn != null) {
            this.listeners.clear();
            this.handleConn.close();
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
            }
            finally {
                this.physicalConn = null;
            }
        }
    }

    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        if (this.handleConn != null) {
            this.handleConn.close();
        }
        this.handleConn = new PooledJdbcConnection(this.physicalConn);
        return this.handleConn;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.debugCode("addConnectionEventListener(listener);");
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.debugCode("removeConnectionEventListener(listener);");
        this.listeners.remove(connectionEventListener);
    }

    void closedHandle() {
        this.debugCode("closedHandle();");
        for (ConnectionEventListener connectionEventListener : New.arrayList(this.listeners)) {
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            connectionEventListener.connectionClosed(connectionEvent);
        }
        this.handleConn = null;
    }

    public int getTransactionTimeout() {
        this.debugCodeCall("getTransactionTimeout");
        return 0;
    }

    public boolean setTransactionTimeout(int n) {
        this.debugCodeCall("setTransactionTimeout", n);
        return false;
    }

    public boolean isSameRM(XAResource xAResource) {
        this.debugCode("isSameRM(xares);");
        return xAResource == this;
    }

    public Xid[] recover(int n) throws XAException {
        this.debugCodeCall("recover", this.quoteFlags(n));
        this.checkOpen();
        Statement statement = null;
        try {
            Xid[] xidArray;
            statement = this.physicalConn.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT ORDER BY TRANSACTION");
            ArrayList<Xid> arrayList = New.arrayList();
            while (resultSet.next()) {
                xidArray = resultSet.getString("TRANSACTION");
                int n2 = this.getNextId(14);
                JdbcXid jdbcXid = new JdbcXid(this.factory, n2, (String)xidArray);
                arrayList.add(jdbcXid);
            }
            resultSet.close();
            xidArray = new Xid[arrayList.size()];
            arrayList.toArray(xidArray);
            Xid[] xidArray2 = xidArray;
            return xidArray2;
        }
        catch (SQLException sQLException) {
            throw new XAException(-3);
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("prepare(" + this.quoteXid(xid) + ");");
        }
        this.checkOpen();
        if (!this.currentTransaction.equals(xid)) {
            throw new XAException(-5);
        }
        Statement statement = null;
        try {
            statement = this.physicalConn.createStatement();
            this.currentTransactionId = nextTransactionId++;
            statement.execute("PREPARE COMMIT TX_" + this.currentTransactionId);
        }
        catch (SQLException sQLException) {
            throw this.convertException(sQLException);
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
        return 0;
    }

    public void forget(Xid xid) {
        if (this.isDebugEnabled()) {
            this.debugCode("forget(" + this.quoteXid(xid) + ");");
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("rollback(" + this.quoteXid(xid) + ");");
        }
        try {
            this.physicalConn.rollback();
        }
        catch (SQLException sQLException) {
            throw this.convertException(sQLException);
        }
        this.currentTransaction = null;
    }

    public void end(Xid xid, int n) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("end(" + this.quoteXid(xid) + ", " + this.quoteFlags(n) + ");");
        }
        if (n == 0x2000000) {
            return;
        }
        if (!this.currentTransaction.equals(xid)) {
            throw new XAException(-9);
        }
    }

    public void start(Xid xid, int n) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("start(" + this.quoteXid(xid) + ", " + this.quoteFlags(n) + ");");
        }
        if (n == 0x8000000) {
            return;
        }
        if (this.currentTransaction != null) {
            throw new XAException(-4);
        }
        try {
            this.physicalConn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw this.convertException(sQLException);
        }
        this.currentTransaction = xid;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        Statement statement;
        block6: {
            if (this.isDebugEnabled()) {
                this.debugCode("commit(" + this.quoteXid(xid) + ", " + bl + ");");
            }
            statement = null;
            try {
                if (bl) {
                    this.physicalConn.commit();
                    break block6;
                }
                statement = this.physicalConn.createStatement();
                statement.execute("COMMIT TRANSACTION TX_" + this.currentTransactionId);
            }
            catch (SQLException sQLException) {
                try {
                    throw this.convertException(sQLException);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeSilently(statement);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeSilently(statement);
        this.currentTransaction = null;
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.user;
    }

    private XAException convertException(SQLException sQLException) {
        XAException xAException = new XAException(sQLException.getMessage());
        xAException.initCause(sQLException);
        return xAException;
    }

    private String quoteXid(Xid xid) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"f:").append(xid.getFormatId()).append(",bq:").append(ByteUtils.convertBytesToString(xid.getBranchQualifier())).append(",gx:").append(ByteUtils.convertBytesToString(xid.getGlobalTransactionId())).append(",c:").append(xid.getClass().getName()).append("\"");
        return stringBuilder.toString();
    }

    private String quoteFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x800000) != 0) {
            stringBuilder.append("|XAResource.TMENDRSCAN");
        }
        if ((n & 0x20000000) != 0) {
            stringBuilder.append("|XAResource.TMFAIL");
        }
        if ((n & 0x200000) != 0) {
            stringBuilder.append("|XAResource.TMJOIN");
        }
        if ((n & 0x40000000) != 0) {
            stringBuilder.append("|XAResource.TMONEPHASE");
        }
        if ((n & 0x8000000) != 0) {
            stringBuilder.append("|XAResource.TMRESUME");
        }
        if ((n & 0x1000000) != 0) {
            stringBuilder.append("|XAResource.TMSTARTRSCAN");
        }
        if ((n & 0x4000000) != 0) {
            stringBuilder.append("|XAResource.TMSUCCESS");
        }
        if ((n & 0x2000000) != 0) {
            stringBuilder.append("|XAResource.TMSUSPEND");
        }
        if ((n & 3) != 0) {
            stringBuilder.append("|XAResource.XA_RDONLY");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("|XAResource.TMNOFLAGS");
        }
        return stringBuilder.toString().substring(1);
    }

    private void checkOpen() throws XAException {
        if (this.physicalConn == null) {
            throw new XAException(-3);
        }
    }

    static {
        Driver.load();
    }

    class PooledJdbcConnection
    extends JdbcConnection {
        private boolean isClosed;

        public PooledJdbcConnection(JdbcConnection jdbcConnection) {
            super(jdbcConnection);
            this.openStackTrace = new Exception("Stack Trace");
        }

        public synchronized void close() throws SQLException {
            if (!this.isClosed) {
                this.rollback();
                this.setAutoCommit(true);
                JdbcXAConnection.this.closedHandle();
                this.isClosed = true;
            }
        }

        public synchronized boolean isClosed() throws SQLException {
            return this.isClosed || super.isClosed();
        }

        protected synchronized void checkClosed(boolean bl) throws SQLException {
            if (this.isClosed) {
                throw Message.getSQLException(90007);
            }
            super.checkClosed(bl);
        }

        protected void finalize() {
            if (!SysProperties.runFinalize) {
                return;
            }
            Trace trace = this.getTrace();
            try {
                if (!this.isClosed()) {
                    trace.error("Pooled connection not closed", this.openStackTrace);
                    JdbcXAConnection.this.close();
                }
            }
            catch (SQLException sQLException) {
                trace.debug("finalize", sQLException);
            }
        }
    }
}

