/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.StateflowBlock;

public class StateflowUtil {
    private static final String M = "m";
    private static final String SF_MODEL = "rt = sfroot; ? = rt.find('-isa', 'Simulink.BlockDiagram', '-and', 'Name', '?');";
    private static final String FIND_ALL = "list = ?.find('-isa','Stateflow.Object');";
    private static final String FIND_BLOCK_TYPE = "list = ?.find('-isa','?');";
    private static final String GET_IDS = "get(list, 'Id');";
    private static final String FIND_BY_ID = "? = ?.find('Id', ?);";
    private static final String FIND_BY_PATH = "? = ?.find('Path', '?');";
    private static final String FIND_BY_TYPE_PATH = "? = ?.find('-isa', '?', 'Path', '?');";

    public static String randomHandleName() {
        return "e" + UUID.randomUUID().toString().replace("-", "").substring(0, 10);
    }

    public static void getBlockHandleAs(StateflowBlock block, String varName) throws MatlabException {
        StateflowUtil.modelHandleAsM(block);
        if (block.getId() != null) {
            block.getEngine().eval(FIND_BY_ID, varName, M, block.getId().intValue());
        } else if (block.getPath() != null) {
            block.getEngine().eval(FIND_BY_TYPE_PATH, varName, M, block.getType(), block.getPath());
        }
    }

    public static String getBlockHandle(StateflowBlock block) throws MatlabException {
        String varName = StateflowUtil.randomHandleName();
        StateflowUtil.getBlockHandleAs(block, varName);
        return varName;
    }

    public static String getBlockHandleFromId(SimulinkModel model, MatlabEngine engine, Integer id) throws MatlabException {
        StateflowUtil.modelHandleAsM(model);
        String varName = StateflowUtil.randomHandleName();
        engine.eval(FIND_BY_ID, varName, M, id);
        return varName;
    }

    public static String getBlockHandleFromPath(SimulinkModel model, MatlabEngine engine, String path) throws MatlabException {
        StateflowUtil.modelHandleAsM(model);
        String varName = StateflowUtil.randomHandleName();
        engine.eval(FIND_BY_PATH, varName, M, path);
        return varName;
    }

    public static String getBlockHandleFromTypeAndPath(SimulinkModel model, MatlabEngine engine, String type, String path) throws MatlabException {
        StateflowUtil.modelHandleAsM(model);
        String varName = StateflowUtil.randomHandleName();
        engine.eval(FIND_BY_TYPE_PATH, varName, M, type, path);
        return varName;
    }

    public static String getBlockHandleFromId(SimulinkModel model, MatlabEngine engine, Double id) throws MatlabException {
        return StateflowUtil.getBlockHandleFromId(model, engine, id.intValue());
    }

    public static void modelHandleAsM(ISimulinkModelElement obj) throws MatlabException {
        StateflowUtil.modelHandleAs(obj, M);
    }

    public static void modelHandleAsM(SimulinkModel model) throws MatlabException {
        StateflowUtil.modelHandleAs(model, M);
    }

    public static void modelHandleAs(ISimulinkModelElement obj, String as) throws MatlabException {
        StateflowUtil.modelHandleAs((SimulinkModel)obj.getOwningModel(), as);
    }

    public static void modelHandleAs(SimulinkModel model, String as) throws MatlabException {
        String modelName = model.getSimulinkModelName();
        model.getEngine().eval(SF_MODEL, as, modelName);
    }

    public static String handleMethod(StateflowBlock block, String methodName, Object[] parameters) throws MatlabException {
        String h = StateflowUtil.getBlockHandle(block);
        String cmd = "result = " + h + "." + methodName;
        if (parameters != null && parameters.length > 0) {
            cmd = String.valueOf(cmd) + "(";
            List<Object> list = Arrays.asList(parameters);
            for (Object parameter : list) {
                if (list.indexOf(parameter) != 0) {
                    cmd = String.valueOf(cmd) + ", ";
                }
                cmd = parameter instanceof String ? String.valueOf(cmd) + "'" + String.valueOf(parameter) + "'" : String.valueOf(cmd) + parameter;
            }
            cmd = String.valueOf(cmd) + ")";
        }
        cmd = String.valueOf(cmd) + ";";
        return cmd;
    }

    public static Collection<ISimulinkModelElement> getAllStateflowBlocksFromModel(SimulinkModel model, MatlabEngine engine) throws MatlabException {
        StateflowUtil.modelHandleAsM(model);
        Object ids = engine.evalWithSetupAndResult(FIND_ALL, GET_IDS, M);
        return StateflowUtil.getTypeList(model, engine, ids);
    }

    public static Collection<ISimulinkModelElement> getAllOfStateflowTypeFromModel(SimulinkModel model, MatlabEngine engine, String type) throws MatlabException {
        try {
            StateflowUtil.modelHandleAsM(model);
            Object ids = engine.evalWithSetupAndResult(FIND_BLOCK_TYPE, GET_IDS, M, type);
            return StateflowUtil.getTypeList(model, engine, ids);
        }
        catch (MatlabException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static Collection<ISimulinkModelElement> getTypeList(SimulinkModel model, MatlabEngine engine, Object ids) {
        return StateflowUtil.getStateflowBlocks(model, engine, ids).stream().map(e -> e).collect(Collectors.toList());
    }

    public static Collection<StateflowBlock> getStateflowBlocks(SimulinkModel model, MatlabEngine engine, Object ids) {
        if (ids == null) {
            return Collections.emptyList();
        }
        ArrayList<StateflowBlock> list = new ArrayList<StateflowBlock>();
        if (ids instanceof List) {
            try {
                for (Double id : (List)ids) {
                    list.add(new StateflowBlock(model, engine, id));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ids instanceof Double) {
            try {
                list.add(new StateflowBlock(model, engine, (Double)ids));
            }
            catch (MatlabException e1) {
                e1.printStackTrace();
            }
        }
        return list;
    }

    public static StateflowBlock cast(Object object) {
        return null;
    }
}

