/*******************************************************************************
 * Copyright (c) 2008 The University of York.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     Louis Rose - initial API and implementation
 ******************************************************************************/
package org.eclipse.epsilon.hutn.exceptions;

public class HutnConfigFileNotFoundException extends HutnTranslationException {

	// Generated by Eclipse
	private static final long serialVersionUID = -4237724925006932119L;
	
	private final String path;
	private final int line;
	private final int col;

	public HutnConfigFileNotFoundException(String path, int line, int col) {
		super("File not found: " + path);
		
		this.path = path;
		this.line = line;
		this.col  = col;
	}
	
	public String getPath() {
		return path;
	}
	
	public int getLine() {
		return line;
	}
	
	public int getColumn() {
		return col;
	}
}
