/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gdata.model.AttributeCreator;
import com.google.gdata.model.AttributeCreatorImpl;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementTransform;
import com.google.gdata.model.ElementValidator;
import com.google.gdata.model.Metadata;
import com.google.gdata.model.MetadataCreatorImpl;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.Path;
import com.google.gdata.model.QName;
import com.google.gdata.model.TransformKey;
import com.google.gdata.model.VirtualElementHolder;
import com.google.gdata.util.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ElementCreatorImpl
extends MetadataCreatorImpl
implements ElementCreator {
    private static final QName UNDECLARED = new QName("**UNDECLARED**");
    static final AttributeKey<Void> ATTRIBUTE_MARKER = AttributeKey.of(UNDECLARED, Void.class);
    static final ElementKey<Void, Element> ELEMENT_MARKER = ElementKey.of(UNDECLARED, Void.class, Element.class);
    private final ElementKey<?, ?> elementKey;
    private ElementMetadata.Cardinality cardinality;
    private Boolean contentRequired;
    private ElementValidator validator;
    private Object properties;
    private VirtualElementHolder virtualElementHolder;
    private boolean flattened;
    private final Map<QName, AttributeInfo> attributes = Maps.newLinkedHashMap();
    private final Map<QName, ElementInfo> elements = Maps.newLinkedHashMap();
    private final Map<String, ElementKey<?, ?>> adaptations = Maps.newLinkedHashMap();
    private Set<AttributeKey<?>> attributeWhitelist;
    private Set<ElementKey<?, ?>> elementWhitelist;

    ElementCreatorImpl(MetadataRegistry registry, TransformKey transformKey) {
        super(registry, transformKey);
        MetadataKey<?> key = transformKey.getKey();
        Preconditions.checkArgument(key instanceof ElementKey, "Key must be to an element.");
        this.elementKey = (ElementKey)key;
    }

    void merge(ElementCreatorImpl other) {
        super.merge(other);
        if (other.cardinality != null) {
            this.cardinality = other.cardinality;
        }
        if (other.contentRequired != null) {
            this.contentRequired = other.contentRequired;
        }
        if (other.validator != null) {
            this.validator = other.validator;
        }
        if (other.properties != null) {
            this.properties = other.properties;
        }
        if (other.virtualElementHolder != null) {
            this.virtualElementHolder = other.virtualElementHolder;
        }
        if (other.flattened) {
            this.flattened = true;
        }
        for (AttributeInfo attributeInfo : other.attributes.values()) {
            this.addAttribute(attributeInfo.key, attributeInfo.action);
        }
        for (ElementInfo elementInfo : other.elements.values()) {
            this.addElement(elementInfo.key, elementInfo.action);
        }
        this.adaptations.putAll(other.adaptations);
        if (other.attributeWhitelist != null) {
            this.whitelistAttributes(other.attributeWhitelist);
        }
        if (other.elementWhitelist != null) {
            this.whitelistElements(other.elementWhitelist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementCreatorImpl adapt(String kind, ElementKey<?, ?> adaptation) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.adaptations.put(kind, adaptation);
            this.registry.register(adaptation);
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementCreatorImpl setCardinality(ElementMetadata.Cardinality cardinality) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.cardinality = cardinality;
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementCreatorImpl setContentRequired(boolean contentRequired) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.contentRequired = contentRequired;
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementCreatorImpl setValidator(ElementValidator validator) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.validator = validator;
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementCreatorImpl setProperties(Object properties) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.properties = properties;
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementCreatorImpl setSingleVirtualElement(ElementMetadata.SingleVirtualElement singleVirtualElement) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.virtualElementHolder = VirtualElementHolder.of(singleVirtualElement);
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementCreatorImpl setMultipleVirtualElement(ElementMetadata.MultipleVirtualElement multipleVirtualElement) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.virtualElementHolder = VirtualElementHolder.of(multipleVirtualElement);
            this.registry.dirty();
        }
        return this;
    }

    @Override
    void setSource(Path path, TransformKey key) {
        super.setSource(path, key);
        this.setElementPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setElementPath(Path path) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.virtualElementHolder = VirtualElementHolder.of(path);
            this.registry.dirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementCreatorImpl flatten() {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            this.flattened = true;
            this.registry.dirty();
        }
        return this;
    }

    @Override
    public AttributeCreator moveAttribute(AttributeKey<?> attKey, Path path) {
        Preconditions.checkArgument(path.selectsAttribute(), "Path must refer to an attribute.");
        AttributeCreator dest = this.replaceAttribute((AttributeKey)attKey);
        AttributeCreatorImpl source = this.getAttributeCreator(path);
        ((AttributeCreatorImpl)dest).setSource(path, source.getTransformKey());
        source.moved();
        return dest;
    }

    private AttributeCreatorImpl getAttributeCreator(Path path) {
        Preconditions.checkArgument(path.selectsAttribute(), "Must be an attribute path");
        ElementKey<?, ?> parent = path.getParentKey();
        if (parent == null) {
            parent = this.elementKey;
        }
        AttributeKey<?> selected = path.getSelectedAttributeKey();
        return (AttributeCreatorImpl)this.registry.build(parent, selected, this.transformKey.getContext());
    }

    @Override
    public ElementCreator moveElement(ElementKey<?, ?> childKey, Path path) {
        Preconditions.checkArgument(path.selectsElement(), "Path must refer to an element.");
        ElementCreator dest = this.replaceElement((ElementKey)childKey);
        ElementCreatorImpl source = this.getElementCreator(path);
        ((ElementCreatorImpl)dest).setSource(path, source.getTransformKey());
        source.moved();
        return dest;
    }

    private ElementCreatorImpl getElementCreator(Path path) {
        Preconditions.checkArgument(path.selectsElement(), "Must be an element path");
        ElementKey<?, ?> parent = path.getParentKey();
        if (parent == null) {
            parent = this.elementKey;
        }
        ElementKey<?, ?> selected = path.getSelectedElementKey();
        return (ElementCreatorImpl)this.registry.build(parent, selected, this.transformKey.getContext());
    }

    @Override
    public ElementCreatorImpl addUndeclaredAttributeMarker() {
        this.addAttribute((AttributeKey)ATTRIBUTE_MARKER);
        return this;
    }

    @Override
    public AttributeCreatorImpl addAttribute(AttributeKey<?> attributeKey) {
        return this.addAttribute(attributeKey, Action.ADD);
    }

    @Override
    public AttributeCreatorImpl replaceAttribute(AttributeKey<?> attributeKey) {
        return this.addAttribute(attributeKey, Action.REPLACE);
    }

    @Override
    public ElementCreatorImpl orderAndWhitelistAttributes(AttributeKey<?> ... attributeKeys) {
        for (AttributeKey<?> attributeKey : attributeKeys) {
            this.addAttribute((AttributeKey)attributeKey);
        }
        return this.whitelistAttributes((AttributeKey[])attributeKeys);
    }

    @Override
    public ElementCreatorImpl whitelistAttributes(AttributeKey<?> ... attributeKeys) {
        return this.whitelistAttributes(Lists.newArrayList((Object[])attributeKeys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementCreatorImpl whitelistAttributes(Collection<AttributeKey<?>> attributeKeys) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            if (this.attributeWhitelist == null) {
                this.attributeWhitelist = Sets.newHashSet();
            }
            this.attributeWhitelist.addAll(attributeKeys);
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeCreatorImpl addAttribute(AttributeKey<?> attributeKey, Action action) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            QName id = attributeKey.getId();
            if (action == Action.ADD) {
                this.attributes.remove(id);
            }
            this.attributes.put(id, new AttributeInfo(attributeKey, action));
            return (AttributeCreatorImpl)this.registry.build(this.elementKey, attributeKey, this.transformKey.getContext());
        }
    }

    @Override
    public ElementCreatorImpl addUndeclaredElementMarker() {
        this.addElement((ElementKey)ELEMENT_MARKER);
        return this;
    }

    @Override
    public ElementCreatorImpl addElement(ElementKey<?, ?> elementKey) {
        return this.addElement(elementKey, Action.ADD);
    }

    @Override
    public ElementCreatorImpl replaceElement(ElementKey<?, ?> elementKey) {
        return this.addElement(elementKey, Action.REPLACE);
    }

    @Override
    public ElementCreatorImpl orderAndWhitelistElements(ElementKey<?, ?> ... elementKeys) {
        for (ElementKey<?, ?> elementKey : elementKeys) {
            this.addElement((ElementKey)elementKey);
        }
        return this.whitelistElements((ElementKey[])elementKeys);
    }

    @Override
    public ElementCreatorImpl whitelistElements(ElementKey<?, ?> ... elementKeys) {
        return this.whitelistElements(Lists.newArrayList((Object[])elementKeys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementCreatorImpl whitelistElements(Collection<ElementKey<?, ?>> elementKeys) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            if (this.elementWhitelist == null) {
                this.elementWhitelist = Sets.newHashSet();
            }
            this.elementWhitelist.addAll(elementKeys);
            this.registry.dirty();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementCreatorImpl blacklistElements(ElementKey<?, ?> ... elementKeys) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            for (ElementKey<?, ?> elementKey : elementKeys) {
                ((ElementCreatorImpl)this.addElement((ElementKey)elementKey)).setVisible(false);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementCreatorImpl addElement(ElementKey<?, ?> childKey, Action action) {
        MetadataRegistry metadataRegistry = this.registry;
        synchronized (metadataRegistry) {
            QName id = childKey.getId();
            Preconditions.checkNotNull(id);
            if (action == Action.ADD) {
                this.elements.remove(id);
            }
            this.elements.put(id, new ElementInfo(childKey, action));
            return (ElementCreatorImpl)this.registry.build(this.elementKey, childKey, this.transformKey.getContext());
        }
    }

    @Override
    public ElementCreatorImpl setName(QName name) {
        return (ElementCreatorImpl)super.setName(name);
    }

    @Override
    public ElementCreatorImpl setRequired(boolean required) {
        return (ElementCreatorImpl)super.setRequired(required);
    }

    @Override
    public ElementCreatorImpl setVisible(boolean visible) {
        return (ElementCreatorImpl)super.setVisible(visible);
    }

    @Override
    public ElementCreatorImpl setVirtualValue(Metadata.VirtualValue virtualValue) {
        return (ElementCreatorImpl)super.setVirtualValue(virtualValue);
    }

    ElementMetadata.Cardinality getCardinality() {
        return this.cardinality;
    }

    Boolean getContentRequired() {
        return this.contentRequired;
    }

    ElementValidator getValidator() {
        return this.validator;
    }

    Object getProperties() {
        return this.properties;
    }

    VirtualElementHolder getVirtualElementHolder() {
        return this.virtualElementHolder;
    }

    boolean isFlattened() {
        return this.flattened;
    }

    Map<QName, AttributeInfo> getAttributes() {
        return ImmutableMap.copyOf(this.attributes);
    }

    ImmutableSet<AttributeKey<?>> getAttributeSet() {
        Collection<AttributeInfo> infos = this.attributes.values();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (AttributeInfo info : infos) {
            builder.add(info.key);
        }
        return builder.build();
    }

    Map<QName, ElementInfo> getElements() {
        return ImmutableMap.copyOf(this.elements);
    }

    ImmutableSet<ElementKey<?, ?>> getElementSet() {
        Collection<ElementInfo> infos = this.elements.values();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ElementInfo info : infos) {
            builder.add(info.key);
        }
        return builder.build();
    }

    Map<String, ElementKey<?, ?>> getAdaptations() {
        return ImmutableMap.copyOf(this.adaptations);
    }

    Set<AttributeKey<?>> getAttributeWhitelist() {
        return this.attributeWhitelist == null ? null : ImmutableSet.copyOf(this.attributeWhitelist);
    }

    Set<ElementKey<?, ?>> getElementWhitelist() {
        return this.elementWhitelist == null ? null : ImmutableSet.copyOf(this.elementWhitelist);
    }

    ElementTransform toTransform() {
        this.check();
        return ElementTransform.create(this);
    }

    private void check() {
        if (this.virtualElementHolder != null && this.cardinality != null) {
            if (this.cardinality == ElementMetadata.Cardinality.SINGLE) {
                if (this.virtualElementHolder.getSingleVirtualElement() == null) {
                    throw new IllegalStateException("Invalid element transform. MultipleVirtualElement set on an element with single cardinality for key " + this.elementKey);
                }
            } else if (this.virtualElementHolder.getMultipleVirtualElement() == null) {
                throw new IllegalStateException("Invalid element transform. SingleVirtualElement set on an element with multiple cardinality for key " + this.elementKey);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ElementInfo {
        final ElementKey<?, ?> key;
        final Action action;

        ElementInfo(ElementKey<?, ?> key) {
            this(key, Action.REPLACE);
        }

        ElementInfo(ElementKey<?, ?> key, Action action) {
            this.key = key;
            this.action = action;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AttributeInfo {
        final AttributeKey<?> key;
        final Action action;

        AttributeInfo(AttributeKey<?> key) {
            this(key, Action.REPLACE);
        }

        AttributeInfo(AttributeKey<?> key, Action action) {
            this.key = key;
            this.action = action;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        ADD,
        REPLACE;

    }
}

