/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.requirement.model.element;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.MatlabHandleElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.requirement.model.SimulinkRequirementModel;
import org.eclipse.epsilon.emc.simulink.requirement.model.element.ISimulinkRequirementModelElement;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class SimulinkLink
extends SimulinkModelElement
implements ISimulinkRequirementModelElement {
    protected MatlabHandleElement linkHandle;
    Object source;
    Object destination;

    public SimulinkLink(SimulinkRequirementModel model, MatlabEngine engine, ISimulinkModelElement source, ISimulinkModelElement target) throws EolRuntimeException {
        super((IGenericSimulinkModel)model, engine);
        try {
            HandleObject handle = (HandleObject)engine.fevalWithResult("slreq.createLink", new Object[]{source.getHandle(), target.getHandle()});
            this.linkHandle = new MatlabHandleElement((IGenericSimulinkModel)model, engine, handle);
        }
        catch (MatlabException e) {
            throw new EolRuntimeException((Throwable)e);
        }
    }

    public SimulinkLink(SimulinkRequirementModel model, MatlabEngine engine) {
        super((IGenericSimulinkModel)model, engine);
    }

    public SimulinkLink(SimulinkRequirementModel model, MatlabEngine engine, HandleObject id) {
        super((IGenericSimulinkModel)model, engine);
        this.linkHandle = new MatlabHandleElement((IGenericSimulinkModel)model, engine, id);
    }

    public Object getProperty(String property) throws EolRuntimeException {
        return this.linkHandle.getProperty(property);
    }

    public void setProperty(String property, Object value) throws EolRuntimeException {
        this.linkHandle.setProperty(property, value);
    }

    public Collection<String> getAllTypeNamesOf() {
        return Arrays.asList(this.getType(), "Link");
    }

    public boolean deleteElementInModel() throws EolRuntimeException {
        if (this.linkHandle != null) {
            try {
                this.engine.feval("remove", new Object[]{this.linkHandle.getHandle()});
            }
            catch (MatlabException matlabException) {
                return false;
            }
        }
        return true;
    }

    public MatlabHandleElement getHandle() {
        return this.linkHandle;
    }

    public String getType() {
        try {
            return (String)this.getProperty("Type");
        }
        catch (EolRuntimeException eolRuntimeException) {
            return "Link";
        }
    }

    public Boolean isResolved() throws EolRuntimeException {
        return this.isResolved("");
    }

    public Boolean isResolvedSource() throws EolRuntimeException {
        return this.isResolved("Source");
    }

    public Boolean isResolvedDestination() throws EolRuntimeException {
        return this.isResolved("Destination");
    }

    public Boolean isResolved(String location) throws EolRuntimeException {
        try {
            return (Boolean)this.engine.fevalWithResult("isResolved" + location, new Object[]{this.linkHandle.getHandle()});
        }
        catch (MatlabException e) {
            throw new EolRuntimeException((Throwable)e);
        }
    }

    public SimulinkLink setSource(Object source) throws EolRuntimeException {
        if (this.linkHandle == null) {
            try {
                this.source = source;
                if (source instanceof ISimulinkModelElement) {
                    source = ((ISimulinkModelElement)source).getHandle();
                }
                this.engine.feval("setSource", new Object[]{this.linkHandle, source});
                return this;
            }
            catch (MatlabException e) {
                throw new EolRuntimeException((Throwable)e);
            }
        }
        throw new EolRuntimeException("Source already set");
    }

    public Object getSource() throws EolRuntimeException {
        if (this.linkHandle == null) {
            return this.source;
        }
        try {
            return this.engine.fevalWithResult("source", new Object[]{this.linkHandle.getHandle()});
        }
        catch (MatlabException e) {
            throw new EolRuntimeException((Throwable)e);
        }
    }

    public SimulinkLink setDestination(Object destination) throws EolRuntimeException {
        if (this.linkHandle == null) {
            try {
                this.destination = destination;
                if (destination instanceof ISimulinkModelElement) {
                    destination = ((ISimulinkModelElement)destination).getHandle();
                }
                this.engine.feval("setDestination", new Object[]{this.linkHandle, destination});
                return this;
            }
            catch (MatlabException e) {
                throw new EolRuntimeException((Throwable)e);
            }
        }
        throw new EolRuntimeException("Target already set");
    }

    public Object getDestination() throws EolRuntimeException {
        if (this.linkHandle == null) {
            return this.destination;
        }
        try {
            return this.engine.fevalWithResult("destination", new Object[]{this.linkHandle.getHandle()});
        }
        catch (MatlabException e) {
            throw new EolRuntimeException((Throwable)e);
        }
    }
}

